# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.ri_plan import RIPlan
from typing import Optional, Set
from typing_extensions import Self

class GetRIMEInfoResponse(BaseModel):
    """
    GetRIMEInfoResponse
    """ # noqa: E501
    build_version: Optional[StrictStr] = Field(default=None, description="Annotated version of the Robust Intelligence cluster control plane, including the timestamp corresponding to the build.", alias="buildVersion")
    cluster_info_version: Optional[StrictStr] = Field(default=None, description="Version of the Robust Intelligence cluster control plane.", alias="clusterInfoVersion")
    customer_name: Optional[StrictStr] = Field(default=None, description="Name of the customer who owns the license.", alias="customerName")
    expiration_time: Optional[datetime] = Field(default=None, description="Expiration time of the license.", alias="expirationTime")
    grace_period_end_time: Optional[datetime] = Field(default=None, description="After a license is expired, there is a grace period to allow a user to continue to use and update the license.", alias="gracePeriodEndTime")
    ri_plan: Optional[RIPlan] = None
    __properties: ClassVar[List[str]] = ["buildVersion", "clusterInfoVersion", "customerName", "expirationTime", "gracePeriodEndTime", "riPlan"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetRIMEInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetRIMEInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "buildVersion": obj.get("buildVersion"),
            "clusterInfoVersion": obj.get("clusterInfoVersion"),
            "customerName": obj.get("customerName"),
            "expirationTime": obj.get("expirationTime"),
            "gracePeriodEndTime": obj.get("gracePeriodEndTime"),
            "riPlan": obj.get("riPlan")
        })
        return _obj


