# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.job_metadata import JobMetadata
from ri.apiclient.models.validate_model_response import ValidateModelResponse
from typing import Optional, Set
from typing_extensions import Self

class GetValidateModelTaskStatusResponse(BaseModel):
    """
    GetValidateModelTaskStatusResponse
    """ # noqa: E501
    job_metadata: Optional[JobMetadata] = Field(default=None, alias="jobMetadata")
    resp: Optional[ValidateModelResponse] = None
    __properties: ClassVar[List[str]] = ["jobMetadata", "resp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetValidateModelTaskStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job_metadata
        if self.job_metadata:
            _dict['jobMetadata'] = self.job_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resp
        if self.resp:
            _dict['resp'] = self.resp.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetValidateModelTaskStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jobMetadata": JobMetadata.from_dict(obj["jobMetadata"]) if obj.get("jobMetadata") is not None else None,
            "resp": ValidateModelResponse.from_dict(obj["resp"]) if obj.get("resp") is not None else None
        })
        return _obj


