# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.external_api_provider import ExternalApiProvider
from typing import Optional, Set
from typing_extensions import Self

class HttpConnectionSpec(BaseModel):
    """
    HttpConnectionSpec is how a user defines information for how to configure an http request to an LLM.
    """ # noqa: E501
    body_template: Optional[Dict[str, Any]] = Field(default=None, alias="bodyTemplate")
    external_api_provider: Optional[ExternalApiProvider] = None
    headers: Optional[Dict[str, StrictStr]] = Field(default=None, description="Headers that will be sent along with the request payload to the LLM endpoint. These headers can include authentication.")
    response_json_path: StrictStr = Field(description="A json path specifying where in the response json payload we can find the LLM's response response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.", alias="responseJsonPath")
    url: StrictStr
    __properties: ClassVar[List[str]] = ["bodyTemplate", "externalApiProvider", "headers", "responseJsonPath", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HttpConnectionSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HttpConnectionSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bodyTemplate": obj.get("bodyTemplate"),
            "externalApiProvider": obj.get("externalApiProvider"),
            "headers": obj.get("headers"),
            "responseJsonPath": obj.get("responseJsonPath"),
            "url": obj.get("url")
        })
        return _obj


