# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ri.apiclient.models.archived_job_logs import ArchivedJobLogs
from ri.apiclient.models.id import ID
from ri.apiclient.models.job_status import JobStatus
from ri.apiclient.models.job_type import JobType
from ri.apiclient.models.rime_job_data import RimeJobData
from typing import Optional, Set
from typing_extensions import Self

class JobMetadata(BaseModel):
    """
    JobMetadata
    """ # noqa: E501
    agent_id: Optional[ID] = Field(default=None, alias="agentId")
    archived_job_logs: Optional[ArchivedJobLogs] = Field(default=None, alias="archivedJobLogs")
    cancellation_requested: Optional[StrictBool] = Field(default=None, description="Marked when the job has been requested to be cancelled by the user. This is declarative; once the user requests cancellation, the backend will conduct garbage collection on the job in the background and eventually update the status of the job to CANCELLED.", alias="cancellationRequested")
    completion_time: Optional[datetime] = Field(default=None, description="The time the job entered a terminal state.", alias="completionTime")
    creation_time: Optional[datetime] = Field(default=None, description="The time the job was created.", alias="creationTime")
    error_msg: Optional[StrictStr] = Field(default=None, description="User-facing error message for the job.", alias="errorMsg")
    job_data: Optional[RimeJobData] = Field(default=None, alias="jobData")
    job_id: Optional[StrictStr] = Field(default=None, description="The identifier within our job tracking system.", alias="jobId")
    job_progress_str: Optional[StrictStr] = Field(default=None, description="Pretty-printed, human-readable representation of job progress. This will only be populated for Read methods with the FULL job view. To get schema for progress for each type of job, see the field inside that job's job data message (e.g. StressTestJobProgress). Note: this is unstable, do not rely on parsing this.", alias="jobProgressStr")
    job_type: Optional[JobType] = None
    running_time_secs: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total running time a job took to complete if the job is finished or the current running time if the job is still in progress (seconds).", alias="runningTimeSecs")
    start_time: Optional[datetime] = Field(default=None, description="The start time of the job (when the job transitions in state to RUNNING). Note, this may not be populated immediately when the job is created.", alias="startTime")
    status: Optional[JobStatus] = None
    __properties: ClassVar[List[str]] = ["agentId", "archivedJobLogs", "cancellationRequested", "completionTime", "creationTime", "errorMsg", "jobData", "jobId", "jobProgressStr", "jobType", "runningTimeSecs", "startTime", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agent_id
        if self.agent_id:
            _dict['agentId'] = self.agent_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of archived_job_logs
        if self.archived_job_logs:
            _dict['archivedJobLogs'] = self.archived_job_logs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_data
        if self.job_data:
            _dict['jobData'] = self.job_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agentId": ID.from_dict(obj["agentId"]) if obj.get("agentId") is not None else None,
            "archivedJobLogs": ArchivedJobLogs.from_dict(obj["archivedJobLogs"]) if obj.get("archivedJobLogs") is not None else None,
            "cancellationRequested": obj.get("cancellationRequested"),
            "completionTime": obj.get("completionTime"),
            "creationTime": obj.get("creationTime"),
            "errorMsg": obj.get("errorMsg"),
            "jobData": RimeJobData.from_dict(obj["jobData"]) if obj.get("jobData") is not None else None,
            "jobId": obj.get("jobId"),
            "jobProgressStr": obj.get("jobProgressStr"),
            "jobType": obj.get("jobType"),
            "runningTimeSecs": obj.get("runningTimeSecs"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status")
        })
        return _obj


