# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.event_type import EventType
from ri.apiclient.models.id import ID
from ri.apiclient.models.rime_severity import RimeSeverity
from ri.apiclient.models.risk_category_type import RiskCategoryType
from ri.apiclient.models.sort_spec import SortSpec
from ri.apiclient.models.test_category_type import TestCategoryType
from ri.apiclient.models.time_interval import TimeInterval
from typing import Optional, Set
from typing_extensions import Self

class ListDetectionEventsRequestQuery(BaseModel):
    """
    ListDetectionEventsRequestQuery
    """ # noqa: E501
    event_object_id: Optional[StrictStr] = Field(default=None, description="Optional: return a series of detection events for a single object.", alias="eventObjectId")
    event_time_range: Optional[TimeInterval] = Field(default=None, alias="eventTimeRange")
    event_types: Optional[List[EventType]] = Field(default=None, description="Optional: When the list is empty, returns all.", alias="eventTypes")
    firewall_id: Optional[ID] = Field(default=None, alias="firewallId")
    include_resolved: Optional[StrictBool] = Field(default=None, alias="includeResolved")
    risk_category_types: Optional[List[RiskCategoryType]] = Field(default=None, description="Optional: When the list is empty, returns all.", alias="riskCategoryTypes")
    severity: Optional[RimeSeverity] = None
    sort: Optional[SortSpec] = None
    test_categories: Optional[List[TestCategoryType]] = Field(default=None, description="Optional: When the list is empty, return all.", alias="testCategories")
    __properties: ClassVar[List[str]] = ["eventObjectId", "eventTimeRange", "eventTypes", "firewallId", "includeResolved", "riskCategoryTypes", "severity", "sort", "testCategories"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListDetectionEventsRequestQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of event_time_range
        if self.event_time_range:
            _dict['eventTimeRange'] = self.event_time_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of firewall_id
        if self.firewall_id:
            _dict['firewallId'] = self.firewall_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sort
        if self.sort:
            _dict['sort'] = self.sort.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListDetectionEventsRequestQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventObjectId": obj.get("eventObjectId"),
            "eventTimeRange": TimeInterval.from_dict(obj["eventTimeRange"]) if obj.get("eventTimeRange") is not None else None,
            "eventTypes": obj.get("eventTypes"),
            "firewallId": ID.from_dict(obj["firewallId"]) if obj.get("firewallId") is not None else None,
            "includeResolved": obj.get("includeResolved"),
            "riskCategoryTypes": obj.get("riskCategoryTypes"),
            "severity": obj.get("severity"),
            "sort": SortSpec.from_dict(obj["sort"]) if obj.get("sort") is not None else None,
            "testCategories": obj.get("testCategories")
        })
        return _obj


