# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.test_feature_result import TestFeatureResult
from typing import Optional, Set
from typing_extensions import Self

class ListFeatureResultsResponse(BaseModel):
    """
    ListFeatureResultsResponse returns a list of feature results as requested.
    """ # noqa: E501
    feature_results: Optional[List[TestFeatureResult]] = Field(default=None, description="The list of feature results.", alias="featureResults")
    has_more: Optional[StrictBool] = Field(default=None, description="A Boolean flag that specifies whether there are more feature results to return.", alias="hasMore")
    next_page_token: Optional[StrictStr] = Field(default=None, description="A token representing the next page from the list returned by a ListFeatureResults query.", alias="nextPageToken")
    __properties: ClassVar[List[str]] = ["featureResults", "hasMore", "nextPageToken"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListFeatureResultsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in feature_results (list)
        _items = []
        if self.feature_results:
            for _item in self.feature_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['featureResults'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListFeatureResultsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "featureResults": [TestFeatureResult.from_dict(_item) for _item in obj["featureResults"]] if obj.get("featureResults") is not None else None,
            "hasMore": obj.get("hasMore"),
            "nextPageToken": obj.get("nextPageToken")
        })
        return _obj


