# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.firewall_instance_info import FirewallInstanceInfo
from typing import Optional, Set
from typing_extensions import Self

class ListFirewallInstancesResponse(BaseModel):
    """
    ListFirewallInstancesResponse returns the list of firewall instance metadata.
    """ # noqa: E501
    fw_instances: Optional[List[FirewallInstanceInfo]] = Field(default=None, alias="fwInstances")
    has_more: Optional[StrictBool] = Field(default=None, alias="hasMore")
    next_page_token: Optional[StrictStr] = Field(default=None, description="Use this page token in your next ListFirewallInstances call to access the next page of results.", alias="nextPageToken")
    __properties: ClassVar[List[str]] = ["fwInstances", "hasMore", "nextPageToken"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListFirewallInstancesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fw_instances (list)
        _items = []
        if self.fw_instances:
            for _item in self.fw_instances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fwInstances'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListFirewallInstancesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fwInstances": [FirewallInstanceInfo.from_dict(_item) for _item in obj["fwInstances"]] if obj.get("fwInstances") is not None else None,
            "hasMore": obj.get("hasMore"),
            "nextPageToken": obj.get("nextPageToken")
        })
        return _obj


