# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.id import ID
from ri.apiclient.models.metadata import Metadata
from ri.apiclient.models.model_info import ModelInfo
from ri.apiclient.models.validity_status import ValidityStatus
from typing import Optional, Set
from typing_extensions import Self

class Model(BaseModel):
    """
    Model represents a full entry in the Model Registry, with info, metadata, and tags used to identify the model both internally and to an external user.
    """ # noqa: E501
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    creator_id: Optional[ID] = Field(default=None, alias="creatorId")
    external_id: Optional[StrictStr] = Field(default=None, description="external_id is an optional way for a user to identify the model with their own Model IDs.", alias="externalId")
    integration_id: Optional[ID] = Field(default=None, alias="integrationId")
    model_endpoint_integration_id: Optional[ID] = Field(default=None, alias="modelEndpointIntegrationId")
    model_id: Optional[ID] = Field(default=None, alias="modelId")
    model_info: Optional[ModelInfo] = Field(default=None, alias="modelInfo")
    name: Optional[StrictStr] = Field(default=None, description="Name and model_id are both enforced to be unique. Name is user specified. Model_id is internally generated.")
    project_ids: Optional[List[ID]] = Field(default=None, description="For now, a model will only have one project_id associated with it. We make this an array to allow model's to be shared in the future.", alias="projectIds")
    user_metadata: Optional[Metadata] = Field(default=None, alias="userMetadata")
    validity_status: Optional[ValidityStatus] = None
    validity_status_message: Optional[StrictStr] = Field(default=None, description="Information about the validity status of the model, such as why it is invalid. A Case where this would be populated is when the ValidityStatus is not explicitly set to valid by the XP validation task and additional details are required to convey to the user why the model is not valid.", alias="validityStatusMessage")
    __properties: ClassVar[List[str]] = ["creationTime", "creatorId", "externalId", "integrationId", "modelEndpointIntegrationId", "modelId", "modelInfo", "name", "projectIds", "userMetadata", "validityStatus", "validityStatusMessage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Model from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creator_id
        if self.creator_id:
            _dict['creatorId'] = self.creator_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integration_id
        if self.integration_id:
            _dict['integrationId'] = self.integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_endpoint_integration_id
        if self.model_endpoint_integration_id:
            _dict['modelEndpointIntegrationId'] = self.model_endpoint_integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_id
        if self.model_id:
            _dict['modelId'] = self.model_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_info
        if self.model_info:
            _dict['modelInfo'] = self.model_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in project_ids (list)
        _items = []
        if self.project_ids:
            for _item in self.project_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['projectIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of user_metadata
        if self.user_metadata:
            _dict['userMetadata'] = self.user_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Model from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creationTime": obj.get("creationTime"),
            "creatorId": ID.from_dict(obj["creatorId"]) if obj.get("creatorId") is not None else None,
            "externalId": obj.get("externalId"),
            "integrationId": ID.from_dict(obj["integrationId"]) if obj.get("integrationId") is not None else None,
            "modelEndpointIntegrationId": ID.from_dict(obj["modelEndpointIntegrationId"]) if obj.get("modelEndpointIntegrationId") is not None else None,
            "modelId": ID.from_dict(obj["modelId"]) if obj.get("modelId") is not None else None,
            "modelInfo": ModelInfo.from_dict(obj["modelInfo"]) if obj.get("modelInfo") is not None else None,
            "name": obj.get("name"),
            "projectIds": [ID.from_dict(_item) for _item in obj["projectIds"]] if obj.get("projectIds") is not None else None,
            "userMetadata": Metadata.from_dict(obj["userMetadata"]) if obj.get("userMetadata") is not None else None,
            "validityStatus": obj.get("validityStatus"),
            "validityStatusMessage": obj.get("validityStatusMessage")
        })
        return _obj


