# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.classifier_config import ClassifierConfig
from ri.apiclient.models.huggingface_config import HuggingfaceConfig
from ri.apiclient.models.kubernetes_resource_config import KubernetesResourceConfig
from typing import Optional, Set
from typing_extensions import Self

class ModelServerConfig(BaseModel):
    """
    ModelServerConfig
    """ # noqa: E501
    classification_config: Optional[Dict[str, ClassifierConfig]] = Field(default=None, alias="classificationConfig")
    hugging_face_config: Optional[HuggingfaceConfig] = Field(default=None, alias="huggingFaceConfig")
    model_server_image: Optional[StrictStr] = Field(default=None, alias="modelServerImage")
    name: Optional[StrictStr] = None
    resource_config: Optional[KubernetesResourceConfig] = Field(default=None, alias="resourceConfig")
    __properties: ClassVar[List[str]] = ["classificationConfig", "huggingFaceConfig", "modelServerImage", "name", "resourceConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelServerConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in classification_config (dict)
        _field_dict = {}
        if self.classification_config:
            for _key in self.classification_config:
                if self.classification_config[_key]:
                    _field_dict[_key] = self.classification_config[_key].to_dict()
            _dict['classificationConfig'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of hugging_face_config
        if self.hugging_face_config:
            _dict['huggingFaceConfig'] = self.hugging_face_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_config
        if self.resource_config:
            _dict['resourceConfig'] = self.resource_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelServerConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "classificationConfig": dict(
                (_k, ClassifierConfig.from_dict(_v))
                for _k, _v in obj["classificationConfig"].items()
            )
            if obj.get("classificationConfig") is not None
            else None,
            "huggingFaceConfig": HuggingfaceConfig.from_dict(obj["huggingFaceConfig"]) if obj.get("huggingFaceConfig") is not None else None,
            "modelServerImage": obj.get("modelServerImage"),
            "name": obj.get("name"),
            "resourceConfig": KubernetesResourceConfig.from_dict(obj["resourceConfig"]) if obj.get("resourceConfig") is not None else None
        })
        return _obj


