# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.metric_degradation_config import MetricDegradationConfig
from typing import Optional, Set
from typing_extensions import Self

class MonitorConfig(BaseModel):
    """
    Config defines a configuration for a monitor. There are different varities of monitors, such as metric degradation monitors and anomaly monitors. Metric degradation monitors track metrics over time and make up the vast majority of monitors in our system. Anomaly monitors track discrete events such as Security infractions.
    """ # noqa: E501
    anomaly: Optional[Dict[str, Any]] = Field(default=None, description="Anomaly Monitors track events over time that are not associated with metrics. For instance, attacks on a model constitute Anomalies.")
    degradation: Optional[MetricDegradationConfig] = None
    __properties: ClassVar[List[str]] = ["anomaly", "degradation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MonitorConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of degradation
        if self.degradation:
            _dict['degradation'] = self.degradation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MonitorConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "anomaly": obj.get("anomaly"),
            "degradation": MetricDegradationConfig.from_dict(obj["degradation"]) if obj.get("degradation") is not None else None
        })
        return _obj


