# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class NotificationType(str, Enum):
    """
    The type of the notification setting (e.g. Monitoring, Daily Digest, etc.) Each notification setting is triggered on a different cadence and different criteria. For example, daily digests are sent once a day and contain a summary of Stress Tests.   - NOTIFICATION_TYPE_DIGEST: Digest notifications will send a summary of activity for a given project on a given cadence.  - NOTIFICATION_TYPE_JOB_ACTION: Job action will send alerts to users for job events, such as completion or failure. Applies to jobs for stress testing and continuous testing.  - NOTIFICATION_TYPE_MONITORING: When a CT job completes, monitoring notifications trigger when bins contain degradation events. The sensitivity of these alerts is configurable to change alert frequency.
    """

    """
    allowed enum values
    """
    NOTIFICATION_TYPE_DIGEST = 'NOTIFICATION_TYPE_DIGEST'
    NOTIFICATION_TYPE_JOB_ACTION = 'NOTIFICATION_TYPE_JOB_ACTION'
    NOTIFICATION_TYPE_MONITORING = 'NOTIFICATION_TYPE_MONITORING'
    NOTIFICATION_TYPE_UNSPECIFIED = 'NOTIFICATION_TYPE_UNSPECIFIED'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of NotificationType from a JSON string"""
        return cls(json.loads(json_str))


