# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.id import ID
from ri.apiclient.models.model_task import ModelTask
from ri.apiclient.models.profiling_config import ProfilingConfig
from ri.apiclient.models.risk_score import RiskScore
from ri.apiclient.models.run_time_info import RunTimeInfo
from ri.apiclient.models.schedule_info import ScheduleInfo
from ri.apiclient.models.test_category_type import TestCategoryType
from ri.apiclient.models.test_suite_config import TestSuiteConfig
from typing import Optional, Set
from typing_extensions import Self

class Project(BaseModel):
    """
    Project collects test runs for a Stress Test or Continuous Test that relate to a shared machine learning task. Each model for the task is tested by an individual test run. A Continuous Test monitors a currently promoted model over time by continuously testing that model.
    """ # noqa: E501
    active_schedule: Optional[ScheduleInfo] = Field(default=None, alias="activeSchedule")
    continuous_test_categories: Optional[List[TestCategoryType]] = Field(default=None, description="List of test categories to be run in Continuous Testing.", alias="continuousTestCategories")
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    description: Optional[StrictStr] = None
    ethical_consideration: Optional[StrictStr] = Field(default=None, alias="ethicalConsideration")
    firewall_ids: Optional[List[ID]] = Field(default=None, description="List of Firewall IDs that belong to the Project.", alias="firewallIds")
    id: Optional[ID] = None
    is_published: Optional[StrictBool] = Field(default=None, description="Published projects are shown on the Workspace overview page.", alias="isPublished")
    last_test_run_time: Optional[datetime] = Field(default=None, description="Last time a Test Run was successfully uploaded to the Project.", alias="lastTestRunTime")
    model_task: Optional[ModelTask] = None
    name: Optional[StrictStr] = None
    owner_id: Optional[ID] = Field(default=None, alias="ownerId")
    profiling_config: Optional[ProfilingConfig] = Field(default=None, alias="profilingConfig")
    project_test_suite_config: Optional[TestSuiteConfig] = Field(default=None, alias="projectTestSuiteConfig")
    risk_scores: Optional[List[RiskScore]] = Field(default=None, alias="riskScores")
    run_time_info: Optional[RunTimeInfo] = Field(default=None, alias="runTimeInfo")
    stress_test_categories: Optional[List[TestCategoryType]] = Field(default=None, description="List of test categories to be run in Stress Testing.", alias="stressTestCategories")
    tags: Optional[List[StrictStr]] = Field(default=None, description="List of tags associated with the Project to help organizing Projects.")
    use_case: Optional[StrictStr] = Field(default=None, alias="useCase")
    workspace_id: Optional[ID] = Field(default=None, alias="workspaceId")
    __properties: ClassVar[List[str]] = ["activeSchedule", "continuousTestCategories", "creationTime", "description", "ethicalConsideration", "firewallIds", "id", "isPublished", "lastTestRunTime", "modelTask", "name", "ownerId", "profilingConfig", "projectTestSuiteConfig", "riskScores", "runTimeInfo", "stressTestCategories", "tags", "useCase", "workspaceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of active_schedule
        if self.active_schedule:
            _dict['activeSchedule'] = self.active_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in firewall_ids (list)
        _items = []
        if self.firewall_ids:
            for _item in self.firewall_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['firewallIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner_id
        if self.owner_id:
            _dict['ownerId'] = self.owner_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profiling_config
        if self.profiling_config:
            _dict['profilingConfig'] = self.profiling_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_test_suite_config
        if self.project_test_suite_config:
            _dict['projectTestSuiteConfig'] = self.project_test_suite_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in risk_scores (list)
        _items = []
        if self.risk_scores:
            for _item in self.risk_scores:
                if _item:
                    _items.append(_item.to_dict())
            _dict['riskScores'] = _items
        # override the default output from pydantic by calling `to_dict()` of run_time_info
        if self.run_time_info:
            _dict['runTimeInfo'] = self.run_time_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace_id
        if self.workspace_id:
            _dict['workspaceId'] = self.workspace_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "activeSchedule": ScheduleInfo.from_dict(obj["activeSchedule"]) if obj.get("activeSchedule") is not None else None,
            "continuousTestCategories": obj.get("continuousTestCategories"),
            "creationTime": obj.get("creationTime"),
            "description": obj.get("description"),
            "ethicalConsideration": obj.get("ethicalConsideration"),
            "firewallIds": [ID.from_dict(_item) for _item in obj["firewallIds"]] if obj.get("firewallIds") is not None else None,
            "id": ID.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "isPublished": obj.get("isPublished"),
            "lastTestRunTime": obj.get("lastTestRunTime"),
            "modelTask": obj.get("modelTask"),
            "name": obj.get("name"),
            "ownerId": ID.from_dict(obj["ownerId"]) if obj.get("ownerId") is not None else None,
            "profilingConfig": ProfilingConfig.from_dict(obj["profilingConfig"]) if obj.get("profilingConfig") is not None else None,
            "projectTestSuiteConfig": TestSuiteConfig.from_dict(obj["projectTestSuiteConfig"]) if obj.get("projectTestSuiteConfig") is not None else None,
            "riskScores": [RiskScore.from_dict(_item) for _item in obj["riskScores"]] if obj.get("riskScores") is not None else None,
            "runTimeInfo": RunTimeInfo.from_dict(obj["runTimeInfo"]) if obj.get("runTimeInfo") is not None else None,
            "stressTestCategories": obj.get("stressTestCategories"),
            "tags": obj.get("tags"),
            "useCase": obj.get("useCase"),
            "workspaceId": ID.from_dict(obj["workspaceId"]) if obj.get("workspaceId") is not None else None
        })
        return _obj


