# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RankingInfo(BaseModel):
    """
    RankingInfo
    """ # noqa: E501
    drop_query_id: Optional[StrictBool] = Field(default=None, description="Whether to drop the query ID column from the dataset to avoid passing as a feature to the model.", alias="dropQueryId")
    nqueries: Optional[StrictStr] = Field(default=None, description="Number of queries to consider. If null, will use all queries.")
    nrows_per_query: Optional[StrictStr] = Field(default=None, description="Number of rows to use per query. If null, will use all rows.", alias="nrowsPerQuery")
    query_col: Optional[StrictStr] = Field(default=None, description="Name of column in dataset that contains the query ids.", alias="queryCol")
    __properties: ClassVar[List[str]] = ["dropQueryId", "nqueries", "nrowsPerQuery", "queryCol"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RankingInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RankingInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dropQueryId": obj.get("dropQueryId"),
            "nqueries": obj.get("nqueries"),
            "nrowsPerQuery": obj.get("nrowsPerQuery"),
            "queryCol": obj.get("queryCol")
        })
        return _obj


