# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.ct_info import CTInfo
from ri.apiclient.models.data_info import DataInfo
from ri.apiclient.models.id import ID
from ri.apiclient.models.metadata import Metadata
from typing import Optional, Set
from typing_extensions import Self

class RegisterDatasetRequest(BaseModel):
    """
    RegisterDatasetRequest registers a dataset for a given project with a source the data can be pulled from. Users can also specify metadata.
    """ # noqa: E501
    agent_id: Optional[ID] = Field(default=None, alias="agentId")
    ct_info: Optional[CTInfo] = Field(default=None, alias="ctInfo")
    data_info: Optional[DataInfo] = Field(default=None, alias="dataInfo")
    integration_id: Optional[ID] = Field(default=None, alias="integrationId")
    metadata: Optional[Metadata] = None
    name: StrictStr = Field(description="Unique name of the Dataset.")
    project_id: Optional[Dict[str, Any]] = Field(default=None, description="Uniquely specifies a Project.", alias="projectId")
    skip_validation: Optional[StrictBool] = Field(default=None, description="The parameter is deprecated since 2.7, and does not have any effect. Will always validate the dataset you are registering. Validation ensures that the dataset is valid for Robust Intelligence's systems.", alias="skipValidation")
    __properties: ClassVar[List[str]] = ["agentId", "ctInfo", "dataInfo", "integrationId", "metadata", "name", "projectId", "skipValidation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RegisterDatasetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agent_id
        if self.agent_id:
            _dict['agentId'] = self.agent_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ct_info
        if self.ct_info:
            _dict['ctInfo'] = self.ct_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_info
        if self.data_info:
            _dict['dataInfo'] = self.data_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integration_id
        if self.integration_id:
            _dict['integrationId'] = self.integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RegisterDatasetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agentId": ID.from_dict(obj["agentId"]) if obj.get("agentId") is not None else None,
            "ctInfo": CTInfo.from_dict(obj["ctInfo"]) if obj.get("ctInfo") is not None else None,
            "dataInfo": DataInfo.from_dict(obj["dataInfo"]) if obj.get("dataInfo") is not None else None,
            "integrationId": ID.from_dict(obj["integrationId"]) if obj.get("integrationId") is not None else None,
            "metadata": Metadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "name": obj.get("name"),
            "projectId": obj.get("projectId"),
            "skipValidation": obj.get("skipValidation")
        })
        return _obj


