# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.id import ID
from ri.apiclient.models.metadata import Metadata
from ri.apiclient.models.model_info import ModelInfo
from typing import Optional, Set
from typing_extensions import Self

class RegisterModelRequest(BaseModel):
    """
    RegisterModelRequest registers a model for a given project with a source the model can be pulled from. Users can also specify metadata.
    """ # noqa: E501
    agent_id: Optional[ID] = Field(default=None, alias="agentId")
    external_id: Optional[StrictStr] = Field(default=None, description="External ID that can be used to identify the model.", alias="externalId")
    integration_id: Optional[ID] = Field(default=None, alias="integrationId")
    metadata: Optional[Metadata] = None
    model_endpoint_integration_id: Optional[ID] = Field(default=None, alias="modelEndpointIntegrationId")
    model_info: Optional[ModelInfo] = Field(default=None, alias="modelInfo")
    name: StrictStr = Field(description="Unique name of the Model.")
    project_id: Optional[Dict[str, Any]] = Field(default=None, description="Uniquely specifies a Project.", alias="projectId")
    skip_validation: Optional[StrictBool] = Field(default=None, description="The parameter is deprecated since 2.7, and does not have any effect. Will always validate the model you are registering. Validation ensures that the model is valid for Robust Intelligence's systems.", alias="skipValidation")
    __properties: ClassVar[List[str]] = ["agentId", "externalId", "integrationId", "metadata", "modelEndpointIntegrationId", "modelInfo", "name", "projectId", "skipValidation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RegisterModelRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agent_id
        if self.agent_id:
            _dict['agentId'] = self.agent_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integration_id
        if self.integration_id:
            _dict['integrationId'] = self.integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_endpoint_integration_id
        if self.model_endpoint_integration_id:
            _dict['modelEndpointIntegrationId'] = self.model_endpoint_integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_info
        if self.model_info:
            _dict['modelInfo'] = self.model_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RegisterModelRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agentId": ID.from_dict(obj["agentId"]) if obj.get("agentId") is not None else None,
            "externalId": obj.get("externalId"),
            "integrationId": ID.from_dict(obj["integrationId"]) if obj.get("integrationId") is not None else None,
            "metadata": Metadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "modelEndpointIntegrationId": ID.from_dict(obj["modelEndpointIntegrationId"]) if obj.get("modelEndpointIntegrationId") is not None else None,
            "modelInfo": ModelInfo.from_dict(obj["modelInfo"]) if obj.get("modelInfo") is not None else None,
            "name": obj.get("name"),
            "projectId": obj.get("projectId"),
            "skipValidation": obj.get("skipValidation")
        })
        return _obj


