# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.continuous_incremental_test import ContinuousIncrementalTest
from ri.apiclient.models.cross_plane_response import CrossPlaneResponse
from ri.apiclient.models.rime_job_data_generative_model_test import RimeJobDataGenerativeModelTest
from ri.apiclient.models.scan import Scan
from ri.apiclient.models.stress_test import StressTest
from typing import Optional, Set
from typing_extensions import Self

class RimeJobData(BaseModel):
    """
    Note that progress may not be populated depending on the parameters of the request.
    """ # noqa: E501
    continuous_inc: Optional[ContinuousIncrementalTest] = Field(default=None, alias="continuousInc")
    cross_plane_res: Optional[CrossPlaneResponse] = Field(default=None, alias="crossPlaneRes")
    file_scan: Optional[Scan] = Field(default=None, alias="fileScan")
    generative_model: Optional[RimeJobDataGenerativeModelTest] = Field(default=None, alias="generativeModel")
    stress: Optional[StressTest] = None
    __properties: ClassVar[List[str]] = ["continuousInc", "crossPlaneRes", "fileScan", "generativeModel", "stress"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RimeJobData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of continuous_inc
        if self.continuous_inc:
            _dict['continuousInc'] = self.continuous_inc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cross_plane_res
        if self.cross_plane_res:
            _dict['crossPlaneRes'] = self.cross_plane_res.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_scan
        if self.file_scan:
            _dict['fileScan'] = self.file_scan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generative_model
        if self.generative_model:
            _dict['generativeModel'] = self.generative_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stress
        if self.stress:
            _dict['stress'] = self.stress.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RimeJobData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "continuousInc": ContinuousIncrementalTest.from_dict(obj["continuousInc"]) if obj.get("continuousInc") is not None else None,
            "crossPlaneRes": CrossPlaneResponse.from_dict(obj["crossPlaneRes"]) if obj.get("crossPlaneRes") is not None else None,
            "fileScan": Scan.from_dict(obj["fileScan"]) if obj.get("fileScan") is not None else None,
            "generativeModel": RimeJobDataGenerativeModelTest.from_dict(obj["generativeModel"]) if obj.get("generativeModel") is not None else None,
            "stress": StressTest.from_dict(obj["stress"]) if obj.get("stress") is not None else None
        })
        return _obj


