# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RimeSeverity(str, Enum):
    """
    Severity specifies the severity level of an event. Depending on the direction of degradation, a metric going below or above a threshold will trigger a higher severity level.   - SEVERITY_UNSPECIFIED: Indicates that no test runs for the specified metric.  - SEVERITY_PASS: Indicates that the specified metric is lower than the low threshold in the case where the Monitor is configured to trigger on an increase of a metric.  - SEVERITY_WARNING: Indicates that the specified metric is higher than the low threshold but still lower than the high threshold, in the case that a Monitor is configured to trigger on an increase of a metric. Warning and Alert severity levels will trigger a Degradation event.  - SEVERITY_ALERT: Indicates that the specified metric is higher than the high threshold in the case that the Monitor is configured to trigger on an increase of a metric. Warning and Alert severity level will trigger a Degradation event.
    """

    """
    allowed enum values
    """
    SEVERITY_UNSPECIFIED = 'SEVERITY_UNSPECIFIED'
    SEVERITY_PASS = 'SEVERITY_PASS'
    SEVERITY_WARNING = 'SEVERITY_WARNING'
    SEVERITY_ALERT = 'SEVERITY_ALERT'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RimeSeverity from a JSON string"""
        return cls(json.loads(json_str))


