# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RoleType(str, Enum):
    """
    RoleType signifies the role the image plays within the registry and the permissions users have for executing actions on the image.   - ROLE_TYPE_SYSTEM: The system role indicates that the image is generated and used by the managed image system and is critical to image building functionality. These images cannot be modified by users. System-level images are generated by the managed image system and are critical for building other images.  - ROLE_TYPE_USER_DEFINED: The user-defined role indicates that the image was created by users and that users can execute arbitrary actions on it.
    """

    """
    allowed enum values
    """
    ROLE_TYPE_SYSTEM = 'ROLE_TYPE_SYSTEM'
    ROLE_TYPE_USER_DEFINED = 'ROLE_TYPE_USER_DEFINED'
    ROLE_TYPE_UNSPECIFIED = 'ROLE_TYPE_UNSPECIFIED'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RoleType from a JSON string"""
        return cls(json.loads(json_str))


