# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RuleSensitivity(str, Enum):
    """
    RuleSensitivity specifies how sensitive to make a Firewall Rule. A higher sensitivity generally means more undesirable content may be flagged. RULE_SENSITIVITY_VERY_HIGH allows for the most aggressive detection.
    """

    """
    allowed enum values
    """
    RULE_SENSITIVITY_UNSPECIFIED = 'RULE_SENSITIVITY_UNSPECIFIED'
    RULE_SENSITIVITY_VERY_LOW = 'RULE_SENSITIVITY_VERY_LOW'
    RULE_SENSITIVITY_LOW = 'RULE_SENSITIVITY_LOW'
    RULE_SENSITIVITY_MEDIUM = 'RULE_SENSITIVITY_MEDIUM'
    RULE_SENSITIVITY_HIGH = 'RULE_SENSITIVITY_HIGH'
    RULE_SENSITIVITY_VERY_HIGH = 'RULE_SENSITIVITY_VERY_HIGH'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RuleSensitivity from a JSON string"""
        return cls(json.loads(json_str))


