# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.dependency import Dependency
from typing import Optional, Set
from typing_extensions import Self

class SecuritydbFileSecurityReport(BaseModel):
    """
    The security report for a single file in the model repository.
    """ # noqa: E501
    creation_time: Optional[datetime] = Field(default=None, description="The time when the file was created.", alias="creationTime")
    dependencies: Optional[List[Dependency]] = Field(default=None, description="The list of all dependencies in the file.")
    filepath: StrictStr = Field(description="The name of the file that was scanned.")
    last_modified_time: Optional[datetime] = Field(default=None, description="The time when the file was last modified.", alias="lastModifiedTime")
    sha256: Optional[StrictStr] = Field(default=None, description="The sha256 of the file that was scanned.")
    size: Optional[StrictInt] = Field(default=None, description="The size of the file in bytes.")
    unsafe_dependencies: Optional[List[Dependency]] = Field(default=None, description="The list of unsafe dependencies.", alias="unsafeDependencies")
    __properties: ClassVar[List[str]] = ["creationTime", "dependencies", "filepath", "lastModifiedTime", "sha256", "size", "unsafeDependencies"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecuritydbFileSecurityReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dependencies (list)
        _items = []
        if self.dependencies:
            for _item in self.dependencies:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dependencies'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in unsafe_dependencies (list)
        _items = []
        if self.unsafe_dependencies:
            for _item in self.unsafe_dependencies:
                if _item:
                    _items.append(_item.to_dict())
            _dict['unsafeDependencies'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecuritydbFileSecurityReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creationTime": obj.get("creationTime"),
            "dependencies": [Dependency.from_dict(_item) for _item in obj["dependencies"]] if obj.get("dependencies") is not None else None,
            "filepath": obj.get("filepath"),
            "lastModifiedTime": obj.get("lastModifiedTime"),
            "sha256": obj.get("sha256"),
            "size": obj.get("size"),
            "unsafeDependencies": [Dependency.from_dict(_item) for _item in obj["unsafeDependencies"]] if obj.get("unsafeDependencies") is not None else None
        })
        return _obj


