# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.securitydb_repo_metadata_license import SecuritydbRepoMetadataLicense
from ri.apiclient.models.securitydb_repo_metadata_reputation import SecuritydbRepoMetadataReputation
from typing import Optional, Set
from typing_extensions import Self

class SecuritydbRepoMetadata(BaseModel):
    """
    SecuritydbRepoMetadata
    """ # noqa: E501
    author: Optional[StrictStr] = Field(default=None, description="The author of the model repository.")
    license: Optional[SecuritydbRepoMetadataLicense] = None
    repo_last_modified_time: Optional[datetime] = Field(default=None, description="The time when the model repository was last modified, inferred from the git history.", alias="repoLastModifiedTime")
    reputation: Optional[SecuritydbRepoMetadataReputation] = None
    tags: Optional[List[StrictStr]] = Field(default=None, description="The tags associated with the model repository.")
    version_info: Optional[StrictStr] = Field(default=None, description="The version info of the model.", alias="versionInfo")
    __properties: ClassVar[List[str]] = ["author", "license", "repoLastModifiedTime", "reputation", "tags", "versionInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecuritydbRepoMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of license
        if self.license:
            _dict['license'] = self.license.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reputation
        if self.reputation:
            _dict['reputation'] = self.reputation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecuritydbRepoMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": obj.get("author"),
            "license": SecuritydbRepoMetadataLicense.from_dict(obj["license"]) if obj.get("license") is not None else None,
            "repoLastModifiedTime": obj.get("repoLastModifiedTime"),
            "reputation": SecuritydbRepoMetadataReputation.from_dict(obj["reputation"]) if obj.get("reputation") is not None else None,
            "tags": obj.get("tags"),
            "versionInfo": obj.get("versionInfo")
        })
        return _obj


