# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.body import Body
from ri.apiclient.models.id import ID
from typing import Optional, Set
from typing_extensions import Self

class StartTestRequest(BaseModel):
    """
    StartTestRequest
    """ # noqa: E501
    agent_id: Optional[ID] = Field(default=None, alias="agentId")
    aws_integration_id: Optional[ID] = Field(default=None, alias="awsIntegrationId")
    body: Optional[Body] = None
    endpoint_payload_template: Optional[StrictStr] = Field(default=None, description="A string template that will be used to create the json payload sent to the LLM endpoint. This template must contain one and only one variable -- prompt_string. This will be replaced at runtime with the prompt used to send to the model. Used for arbitrary HTTP requests to models.  The template uses \" and \" as the opening and closing delimiters around the prompt_string variable name.  Example: '{ \"prompt\": \"{{prompt_string}}\" }' Example: '{ \"message\": { \"llm_prompt\": \"{{prompt_string}}\" } }'", alias="endpointPayloadTemplate")
    http_auth_integration_id: Optional[ID] = Field(default=None, alias="httpAuthIntegrationId")
    http_headers: Optional[Dict[str, StrictStr]] = Field(default=None, alias="httpHeaders")
    model_id: Optional[StrictStr] = Field(default=None, description="If aws_integration_id is set, this field will be the model id used for generative validation for bedrock.", alias="modelId")
    mutual_tls_integration_id: Optional[ID] = Field(default=None, alias="mutualTlsIntegrationId")
    name: Optional[StrictStr] = Field(default=None, description="The name to identify the generative model testing job.")
    response_json_path: Optional[StrictStr] = Field(default=None, description="A json path specifying where in the HTTP response json payload we can find the LLM's response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.  Example (top level field): - Endpoint response json: {\"response\": \"I am an AI Chatbot, how can I assist you?\"} - response_json_path: \"response\"  Example (nested json field): - Endpoint response json: {\"response\": {\"llmResponse\": \"I am an AI Chatbot, how can I assist you?\"}} - response_json_path: \"response.llmResponse\"  Example (extract string from array): - Endpoint response: {\"response\": {\"options\": [\"Hi\", \"Hello there\"], \"count\": 2}} - response_json_path: \"response.options.1\"  Example (periods in field names): - Endpoint response: {\"llm.response\": \"hello\"} - response_json_path: \"llm\\\\.response\"  The syntax uses dot notation only, such as \"myfield.myotherfield\" or \"myarray.1\".", alias="responseJsonPath")
    system_prompt: Optional[StrictStr] = Field(default=None, description="The system prompt that is currently active on the provided endpoint.", alias="systemPrompt")
    url: Optional[StrictStr] = Field(default=None, description="Parameters for connecting to the user's generative model.")
    workspace_id: Optional[ID] = Field(default=None, alias="workspaceId")
    __properties: ClassVar[List[str]] = ["agentId", "awsIntegrationId", "body", "endpointPayloadTemplate", "httpAuthIntegrationId", "httpHeaders", "modelId", "mutualTlsIntegrationId", "name", "responseJsonPath", "systemPrompt", "url", "workspaceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StartTestRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agent_id
        if self.agent_id:
            _dict['agentId'] = self.agent_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aws_integration_id
        if self.aws_integration_id:
            _dict['awsIntegrationId'] = self.aws_integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of body
        if self.body:
            _dict['body'] = self.body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of http_auth_integration_id
        if self.http_auth_integration_id:
            _dict['httpAuthIntegrationId'] = self.http_auth_integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mutual_tls_integration_id
        if self.mutual_tls_integration_id:
            _dict['mutualTlsIntegrationId'] = self.mutual_tls_integration_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace_id
        if self.workspace_id:
            _dict['workspaceId'] = self.workspace_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StartTestRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agentId": ID.from_dict(obj["agentId"]) if obj.get("agentId") is not None else None,
            "awsIntegrationId": ID.from_dict(obj["awsIntegrationId"]) if obj.get("awsIntegrationId") is not None else None,
            "body": Body.from_dict(obj["body"]) if obj.get("body") is not None else None,
            "endpointPayloadTemplate": obj.get("endpointPayloadTemplate"),
            "httpAuthIntegrationId": ID.from_dict(obj["httpAuthIntegrationId"]) if obj.get("httpAuthIntegrationId") is not None else None,
            "httpHeaders": obj.get("httpHeaders"),
            "modelId": obj.get("modelId"),
            "mutualTlsIntegrationId": ID.from_dict(obj["mutualTlsIntegrationId"]) if obj.get("mutualTlsIntegrationId") is not None else None,
            "name": obj.get("name"),
            "responseJsonPath": obj.get("responseJsonPath"),
            "systemPrompt": obj.get("systemPrompt"),
            "url": obj.get("url"),
            "workspaceId": ID.from_dict(obj["workspaceId"]) if obj.get("workspaceId") is not None else None
        })
        return _obj


