# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from ri.apiclient.models.long_description_tab import LongDescriptionTab
from ri.apiclient.models.table_column import TableColumn
from typing import Optional, Set
from typing_extensions import Self

class TestBatchResultDisplay(BaseModel):
    """
    Display contains information for displaying the test case in the RI web app. The contents of each field are unstable; it is not recommended to parse them programmatically.
    """ # noqa: E501
    description_html: Optional[StrictStr] = Field(default=None, description="Description of the test batch result that may contain HTML.", alias="descriptionHtml")
    long_description_tabs: Optional[List[LongDescriptionTab]] = Field(default=None, description="More detailed information about the test batch.", alias="longDescriptionTabs")
    summary_details: Optional[Union[Annotated[bytes, Field(strict=True)], Annotated[str, Field(strict=True)]]] = Field(default=None, description="Summary details are marshalled JSON, the field is not used and is empty.", alias="summaryDetails")
    table_columns_to_show: Optional[List[TableColumn]] = Field(default=None, alias="tableColumnsToShow")
    __properties: ClassVar[List[str]] = ["descriptionHtml", "longDescriptionTabs", "summaryDetails", "tableColumnsToShow"]

    @field_validator('summary_details')
    def summary_details_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$", value):
            raise ValueError(r"must validate the regular expression /^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestBatchResultDisplay from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in long_description_tabs (list)
        _items = []
        if self.long_description_tabs:
            for _item in self.long_description_tabs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['longDescriptionTabs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in table_columns_to_show (list)
        _items = []
        if self.table_columns_to_show:
            for _item in self.table_columns_to_show:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tableColumnsToShow'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestBatchResultDisplay from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "descriptionHtml": obj.get("descriptionHtml"),
            "longDescriptionTabs": [LongDescriptionTab.from_dict(_item) for _item in obj["longDescriptionTabs"]] if obj.get("longDescriptionTabs") is not None else None,
            "summaryDetails": obj.get("summaryDetails"),
            "tableColumnsToShow": [TableColumn.from_dict(_item) for _item in obj["tableColumnsToShow"]] if obj.get("tableColumnsToShow") is not None else None
        })
        return _obj


