# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ri.apiclient.models.float_list import FloatList
from ri.apiclient.models.int_list import IntList
from ri.apiclient.models.str_list import StrList
from ri.apiclient.models.test_case_monitor_info import TestCaseMonitorInfo
from ri.apiclient.models.test_metric_category import TestMetricCategory
from typing import Optional, Set
from typing_extensions import Self

class TestMetric(BaseModel):
    """
    TestMetric
    """ # noqa: E501
    category: Optional[TestMetricCategory] = None
    empty: Optional[Dict[str, Any]] = None
    float_list: Optional[FloatList] = Field(default=None, alias="floatList")
    float_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="floatValue")
    int_list: Optional[IntList] = Field(default=None, alias="intList")
    int_value: Optional[StrictStr] = Field(default=None, alias="intValue")
    metric: Optional[StrictStr] = None
    str_list: Optional[StrList] = Field(default=None, alias="strList")
    str_value: Optional[StrictStr] = Field(default=None, alias="strValue")
    test_case_monitor_info: Optional[TestCaseMonitorInfo] = Field(default=None, alias="testCaseMonitorInfo")
    __properties: ClassVar[List[str]] = ["category", "empty", "floatList", "floatValue", "intList", "intValue", "metric", "strList", "strValue", "testCaseMonitorInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestMetric from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of float_list
        if self.float_list:
            _dict['floatList'] = self.float_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of int_list
        if self.int_list:
            _dict['intList'] = self.int_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of str_list
        if self.str_list:
            _dict['strList'] = self.str_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of test_case_monitor_info
        if self.test_case_monitor_info:
            _dict['testCaseMonitorInfo'] = self.test_case_monitor_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestMetric from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "empty": obj.get("empty"),
            "floatList": FloatList.from_dict(obj["floatList"]) if obj.get("floatList") is not None else None,
            "floatValue": obj.get("floatValue"),
            "intList": IntList.from_dict(obj["intList"]) if obj.get("intList") is not None else None,
            "intValue": obj.get("intValue"),
            "metric": obj.get("metric"),
            "strList": StrList.from_dict(obj["strList"]) if obj.get("strList") is not None else None,
            "strValue": obj.get("strValue"),
            "testCaseMonitorInfo": TestCaseMonitorInfo.from_dict(obj["testCaseMonitorInfo"]) if obj.get("testCaseMonitorInfo") is not None else None
        })
        return _obj


