# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.id import ID
from ri.apiclient.models.profiling_config import ProfilingConfig
from ri.apiclient.models.ref_eval_datasets import RefEvalDatasets
from ri.apiclient.models.run_time_info import RunTimeInfo
from ri.apiclient.models.test_category_type import TestCategoryType
from ri.apiclient.models.test_suite_config import TestSuiteConfig
from typing import Optional, Set
from typing_extensions import Self

class TestRunConfig(BaseModel):
    """
    TestRunConfig contains the configuration necessary to run a Stress Test. model_id and data_info are required fields.
    """ # noqa: E501
    categories: Optional[List[TestCategoryType]] = Field(default=None, description="List of test categories to be run.")
    data_info: RefEvalDatasets = Field(alias="dataInfo")
    model_id: ID = Field(alias="modelId")
    profiling_config: Optional[ProfilingConfig] = Field(default=None, alias="profilingConfig")
    run_name: StrictStr = Field(description="Name for this Test Run.", alias="runName")
    run_time_info: Optional[RunTimeInfo] = Field(default=None, alias="runTimeInfo")
    test_suite_config: Optional[TestSuiteConfig] = Field(default=None, alias="testSuiteConfig")
    __properties: ClassVar[List[str]] = ["categories", "dataInfo", "modelId", "profilingConfig", "runName", "runTimeInfo", "testSuiteConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestRunConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_info
        if self.data_info:
            _dict['dataInfo'] = self.data_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_id
        if self.model_id:
            _dict['modelId'] = self.model_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profiling_config
        if self.profiling_config:
            _dict['profilingConfig'] = self.profiling_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of run_time_info
        if self.run_time_info:
            _dict['runTimeInfo'] = self.run_time_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of test_suite_config
        if self.test_suite_config:
            _dict['testSuiteConfig'] = self.test_suite_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestRunConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categories": obj.get("categories"),
            "dataInfo": RefEvalDatasets.from_dict(obj["dataInfo"]) if obj.get("dataInfo") is not None else None,
            "modelId": ID.from_dict(obj["modelId"]) if obj.get("modelId") is not None else None,
            "profilingConfig": ProfilingConfig.from_dict(obj["profilingConfig"]) if obj.get("profilingConfig") is not None else None,
            "runName": obj.get("runName"),
            "runTimeInfo": RunTimeInfo.from_dict(obj["runTimeInfo"]) if obj.get("runTimeInfo") is not None else None,
            "testSuiteConfig": TestSuiteConfig.from_dict(obj["testSuiteConfig"]) if obj.get("testSuiteConfig") is not None else None
        })
        return _obj


