# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ri.apiclient.models.id import ID
from ri.apiclient.models.model_task import ModelTask
from ri.apiclient.models.safe_url import SafeURL
from ri.apiclient.models.test_category_type import TestCategoryType
from ri.apiclient.models.test_run_metrics import TestRunMetrics
from ri.apiclient.models.test_task_status import TestTaskStatus
from ri.apiclient.models.test_type import TestType
from ri.apiclient.models.time_interval import TimeInterval
from typing import Optional, Set
from typing_extensions import Self

class TestRunDetail(BaseModel):
    """
    TestRunDetail returns the details for a given test run.
    """ # noqa: E501
    bin_time_interval: Optional[TimeInterval] = Field(default=None, alias="binTimeInterval")
    eval_data_id: Optional[StrictStr] = Field(default=None, description="Uniquely specifies an evaluation dataset.", alias="evalDataId")
    eval_data_sampling_pct: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of the evaluation dataset used for this test. If no sampling occurred, this will be 1.0.", alias="evalDataSamplingPct")
    metrics: Optional[TestRunMetrics] = None
    model_id: Optional[ID] = Field(default=None, alias="modelId")
    model_task: Optional[ModelTask] = None
    name: Optional[StrictStr] = Field(default=None, description="The name of the Test Run.")
    progress: Optional[StrictStr] = Field(default=None, description="Human-readable succinct message about the progress of the test run.")
    project_id: Optional[ID] = Field(default=None, alias="projectId")
    ref_data_id: Optional[StrictStr] = Field(default=None, description="Uniquely specifies a reference dataset.", alias="refDataId")
    ref_data_sampling_pct: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of the reference dataset used for this test. If no sampling occurred, this will be 1.0.", alias="refDataSamplingPct")
    rime_version: Optional[StrictStr] = Field(default=None, description="The version of Robust Intelligence that ran this test.", alias="rimeVersion")
    schedule_id: Optional[ID] = Field(default=None, alias="scheduleId")
    status: Optional[TestTaskStatus] = None
    test_categories: Optional[List[TestCategoryType]] = Field(default=None, description="The list of child references to the category tests belonging to this test run.", alias="testCategories")
    test_run_id: Optional[StrictStr] = Field(default=None, description="Uniquely specifies a Test Run.", alias="testRunId")
    testing_type: Optional[TestType] = None
    upload_time: Optional[datetime] = Field(default=None, description="The upload time of the test run.", alias="uploadTime")
    web_app_url: Optional[SafeURL] = Field(default=None, alias="webAppUrl")
    __properties: ClassVar[List[str]] = ["binTimeInterval", "evalDataId", "evalDataSamplingPct", "metrics", "modelId", "modelTask", "name", "progress", "projectId", "refDataId", "refDataSamplingPct", "rimeVersion", "scheduleId", "status", "testCategories", "testRunId", "testingType", "uploadTime", "webAppUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestRunDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bin_time_interval
        if self.bin_time_interval:
            _dict['binTimeInterval'] = self.bin_time_interval.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model_id
        if self.model_id:
            _dict['modelId'] = self.model_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_id
        if self.project_id:
            _dict['projectId'] = self.project_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule_id
        if self.schedule_id:
            _dict['scheduleId'] = self.schedule_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_app_url
        if self.web_app_url:
            _dict['webAppUrl'] = self.web_app_url.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestRunDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "binTimeInterval": TimeInterval.from_dict(obj["binTimeInterval"]) if obj.get("binTimeInterval") is not None else None,
            "evalDataId": obj.get("evalDataId"),
            "evalDataSamplingPct": obj.get("evalDataSamplingPct"),
            "metrics": TestRunMetrics.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None,
            "modelId": ID.from_dict(obj["modelId"]) if obj.get("modelId") is not None else None,
            "modelTask": obj.get("modelTask"),
            "name": obj.get("name"),
            "progress": obj.get("progress"),
            "projectId": ID.from_dict(obj["projectId"]) if obj.get("projectId") is not None else None,
            "refDataId": obj.get("refDataId"),
            "refDataSamplingPct": obj.get("refDataSamplingPct"),
            "rimeVersion": obj.get("rimeVersion"),
            "scheduleId": ID.from_dict(obj["scheduleId"]) if obj.get("scheduleId") is not None else None,
            "status": obj.get("status"),
            "testCategories": obj.get("testCategories"),
            "testRunId": obj.get("testRunId"),
            "testingType": obj.get("testingType"),
            "uploadTime": obj.get("uploadTime"),
            "webAppUrl": SafeURL.from_dict(obj["webAppUrl"]) if obj.get("webAppUrl") is not None else None
        })
        return _obj


