# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.test_sensitivity import TestSensitivity
from typing import Optional, Set
from typing_extensions import Self

class TestSuiteConfig(BaseModel):
    """
    TestSuiteConfig contains configuration for specific RIME tests in the test suite, configures which test categories to run, and configures the overall test sensitivity settings.
    """ # noqa: E501
    custom_tests: Optional[List[StrictStr]] = Field(default=None, description="A list of JSON custom test configurations.", alias="customTests")
    global_exclude_columns: Optional[List[StrictStr]] = Field(default=None, description="Features to exclude from all tests.", alias="globalExcludeColumns")
    global_test_sensitivity: Optional[TestSensitivity] = None
    individual_tests_config: Optional[StrictStr] = Field(default=None, description="A serialized JSON blob including a config for each test.", alias="individualTestsConfig")
    __properties: ClassVar[List[str]] = ["customTests", "globalExcludeColumns", "globalTestSensitivity", "individualTestsConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestSuiteConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestSuiteConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customTests": obj.get("customTests"),
            "globalExcludeColumns": obj.get("globalExcludeColumns"),
            "globalTestSensitivity": obj.get("globalTestSensitivity"),
            "individualTestsConfig": obj.get("individualTestsConfig")
        })
        return _obj


