# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.test_run_detail import TestRunDetail
from typing import Optional, Set
from typing_extensions import Self

class TestrunresultListTestRunsResponse(BaseModel):
    """
    ListTestRunsResponse returns all the test runs as requested.
    """ # noqa: E501
    has_more: Optional[StrictBool] = Field(default=None, description="A Boolean that specifies whether there are more test runs to return.", alias="hasMore")
    next_page_token: Optional[StrictStr] = Field(default=None, description="A token representing the next page from the list returned by a ListTestRuns query.", alias="nextPageToken")
    test_runs: Optional[List[TestRunDetail]] = Field(default=None, description="The details of the test runs.", alias="testRuns")
    __properties: ClassVar[List[str]] = ["hasMore", "nextPageToken", "testRuns"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestrunresultListTestRunsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in test_runs (list)
        _items = []
        if self.test_runs:
            for _item in self.test_runs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['testRuns'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestrunresultListTestRunsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hasMore": obj.get("hasMore"),
            "nextPageToken": obj.get("nextPageToken"),
            "testRuns": [TestRunDetail.from_dict(_item) for _item in obj["testRuns"]] if obj.get("testRuns") is not None else None
        })
        return _obj


