# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.failing_rows_result import FailingRowsResult
from ri.apiclient.models.result_summary_counts import ResultSummaryCounts
from ri.apiclient.models.rime_severity import RimeSeverity
from ri.apiclient.models.security_event_details import SecurityEventDetails
from ri.apiclient.models.test_batch_result_display import TestBatchResultDisplay
from ri.apiclient.models.test_category_type import TestCategoryType
from ri.apiclient.models.test_metric import TestMetric
from typing import Optional, Set
from typing_extensions import Self

class TestrunresultTestBatchResult(BaseModel):
    """
    TestBatchResult returns the test batch results. Similar to results_upload.proto but with separation of uploading and querying.
    """ # noqa: E501
    category: Optional[StrictStr] = Field(default=None, description="The string field `category` is deprecated in v2.1 and will be removed in v2.3. Please use the enum field test_category instead, which provides the same info.")
    description: Optional[StrictStr] = Field(default=None, description="The description of the test. Note: this is currently identical to the display.description_html field.")
    display: Optional[TestBatchResultDisplay] = None
    duration_in_millis: Optional[StrictStr] = Field(default=None, description="The duration of the test run.", alias="durationInMillis")
    failing_features: Optional[List[StrictStr]] = Field(default=None, description="The list of failing features.", alias="failingFeatures")
    failing_rows_result: Optional[FailingRowsResult] = Field(default=None, alias="failingRowsResult")
    metrics: Optional[List[TestMetric]] = None
    security_test_details: Optional[SecurityEventDetails] = Field(default=None, alias="securityTestDetails")
    severity: Optional[RimeSeverity] = None
    show_in_test_comparisons: Optional[StrictBool] = Field(default=None, description="A Boolean that specifies whether to include the test batch in the test comparison page in the web UI. This field is no longer used, and will be removed in 2.3.", alias="showInTestComparisons")
    summary_counts: Optional[ResultSummaryCounts] = Field(default=None, alias="summaryCounts")
    test_category: Optional[TestCategoryType] = None
    test_name: Optional[StrictStr] = Field(default=None, description="The display-friendly name; for example: 'Categorical Feature Drift'.", alias="testName")
    test_run_id: Optional[StrictStr] = Field(default=None, description="Uniquely specifies a parent Test Run.", alias="testRunId")
    test_type: Optional[StrictStr] = Field(default=None, alias="testType")
    __properties: ClassVar[List[str]] = ["category", "description", "display", "durationInMillis", "failingFeatures", "failingRowsResult", "metrics", "securityTestDetails", "severity", "showInTestComparisons", "summaryCounts", "testCategory", "testName", "testRunId", "testType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestrunresultTestBatchResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of display
        if self.display:
            _dict['display'] = self.display.to_dict()
        # override the default output from pydantic by calling `to_dict()` of failing_rows_result
        if self.failing_rows_result:
            _dict['failingRowsResult'] = self.failing_rows_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in metrics (list)
        _items = []
        if self.metrics:
            for _item in self.metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['metrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of security_test_details
        if self.security_test_details:
            _dict['securityTestDetails'] = self.security_test_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary_counts
        if self.summary_counts:
            _dict['summaryCounts'] = self.summary_counts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestrunresultTestBatchResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "description": obj.get("description"),
            "display": TestBatchResultDisplay.from_dict(obj["display"]) if obj.get("display") is not None else None,
            "durationInMillis": obj.get("durationInMillis"),
            "failingFeatures": obj.get("failingFeatures"),
            "failingRowsResult": FailingRowsResult.from_dict(obj["failingRowsResult"]) if obj.get("failingRowsResult") is not None else None,
            "metrics": [TestMetric.from_dict(_item) for _item in obj["metrics"]] if obj.get("metrics") is not None else None,
            "securityTestDetails": SecurityEventDetails.from_dict(obj["securityTestDetails"]) if obj.get("securityTestDetails") is not None else None,
            "severity": obj.get("severity"),
            "showInTestComparisons": obj.get("showInTestComparisons"),
            "summaryCounts": ResultSummaryCounts.from_dict(obj["summaryCounts"]) if obj.get("summaryCounts") is not None else None,
            "testCategory": obj.get("testCategory"),
            "testName": obj.get("testName"),
            "testRunId": obj.get("testRunId"),
            "testType": obj.get("testType")
        })
        return _obj


