# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.notification_config import NotificationConfig
from ri.apiclient.models.notification_type import NotificationType
from ri.apiclient.models.object_type import ObjectType
from ri.apiclient.models.webhook_config import WebhookConfig
from typing import Optional, Set
from typing_extensions import Self

class UpdateNotificationRequestNotification(BaseModel):
    """
    Notification represents a single notification setting in the backend. It includes the configuration for when notifications should be sent as well as the list of receivers (emails, webhooks, etc.).
    """ # noqa: E501
    config: Optional[NotificationConfig] = None
    emails: Optional[List[StrictStr]] = Field(default=None, description="Emails specify the list of emails to which notifications will be sent.")
    id: Optional[Dict[str, Any]] = Field(default=None, description="Uniquely specifies a Notification.")
    last_send_time: Optional[datetime] = Field(default=None, description="Last send time is the last time the notification was successfully sent.", alias="lastSendTime")
    notification_type: Optional[NotificationType] = None
    object_id: Optional[StrictStr] = Field(default=None, description="Uniquely specifies the object for the notification.", alias="objectId")
    object_type: Optional[ObjectType] = None
    webhooks: Optional[List[WebhookConfig]] = Field(default=None, description="Webhooks are a list of destination webhooks to which notifications will be sent.")
    __properties: ClassVar[List[str]] = ["config", "emails", "id", "lastSendTime", "notificationType", "objectId", "objectType", "webhooks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateNotificationRequestNotification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in webhooks (list)
        _items = []
        if self.webhooks:
            for _item in self.webhooks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['webhooks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateNotificationRequestNotification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "config": NotificationConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "emails": obj.get("emails"),
            "id": obj.get("id"),
            "lastSendTime": obj.get("lastSendTime"),
            "notificationType": obj.get("notificationType"),
            "objectId": obj.get("objectId"),
            "objectType": obj.get("objectType"),
            "webhooks": [WebhookConfig.from_dict(_item) for _item in obj["webhooks"]] if obj.get("webhooks") is not None else None
        })
        return _obj


