# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class UpgradeStatus(str, Enum):
    """
    UpgradeStatus describes the current state of an agent upgrade.   - UPGRADE_STATUS_REQUESTED: The upgrade has been requested but not acknowledged by the operator.  - UPGRADE_STATUS_PENDING: The operator has acknowledged the upgrade request, but it has not started.  - UPGRADE_STATUS_PRE_UPGRADE_CHECKS_FAILED_TO_START: The upgrade failed before pre-upgrade checks started.  - UPGRADE_STATUS_UPGRADE_FAILED_TO_START: The upgrade failed before the upgrade process started.
    """

    """
    allowed enum values
    """
    UPGRADE_STATUS_UNSPECIFIED = 'UPGRADE_STATUS_UNSPECIFIED'
    UPGRADE_STATUS_REQUESTED = 'UPGRADE_STATUS_REQUESTED'
    UPGRADE_STATUS_PENDING = 'UPGRADE_STATUS_PENDING'
    UPGRADE_STATUS_PRE_UPGRADE_CHECKS_FAILED_TO_START = 'UPGRADE_STATUS_PRE_UPGRADE_CHECKS_FAILED_TO_START'
    UPGRADE_STATUS_PRE_UPGRADE_CHECKS_STARTED = 'UPGRADE_STATUS_PRE_UPGRADE_CHECKS_STARTED'
    UPGRADE_STATUS_PRE_UPGRADE_CHECKS_FAILED = 'UPGRADE_STATUS_PRE_UPGRADE_CHECKS_FAILED'
    UPGRADE_STATUS_UPGRADE_FAILED_TO_START = 'UPGRADE_STATUS_UPGRADE_FAILED_TO_START'
    UPGRADE_STATUS_UPGRADE_STARTED = 'UPGRADE_STATUS_UPGRADE_STARTED'
    UPGRADE_STATUS_UPGRADE_SUCCEEDED = 'UPGRADE_STATUS_UPGRADE_SUCCEEDED'
    UPGRADE_STATUS_UPGRADE_FAILED = 'UPGRADE_STATUS_UPGRADE_FAILED'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UpgradeStatus from a JSON string"""
        return cls(json.loads(json_str))


