# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.actor_role import ActorRole
from ri.apiclient.models.id import ID
from ri.apiclient.models.private_info import PrivateInfo
from ri.apiclient.models.role import Role
from typing import Optional, Set
from typing_extensions import Self

class UserDetail(BaseModel):
    """
    Information about a user in RIME.
    """ # noqa: E501
    email: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    id: Optional[ID] = None
    name: Optional[StrictStr] = Field(default=None, description="Name of the user.")
    org_role: Optional[ActorRole] = None
    private_info: Optional[PrivateInfo] = Field(default=None, alias="privateInfo")
    role: Optional[Role] = None
    show_tutorial: Optional[StrictBool] = Field(default=None, alias="showTutorial")
    __properties: ClassVar[List[str]] = ["email", "fullName", "id", "name", "orgRole", "privateInfo", "role", "showTutorial"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of private_info
        if self.private_info:
            _dict['privateInfo'] = self.private_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "fullName": obj.get("fullName"),
            "id": ID.from_dict(obj["id"]) if obj.get("id") is not None else None,
            "name": obj.get("name"),
            "orgRole": obj.get("orgRole"),
            "privateInfo": PrivateInfo.from_dict(obj["privateInfo"]) if obj.get("privateInfo") is not None else None,
            "role": obj.get("role"),
            "showTutorial": obj.get("showTutorial")
        })
        return _obj


