# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserWriteMask(BaseModel):
    """
    Mask for user fields to update.
    """ # noqa: E501
    full_name: Optional[StrictBool] = Field(default=None, description="Specifies whether to update the full name of the user.", alias="fullName")
    org_role: Optional[StrictBool] = Field(default=None, description="Specifies whether to update the organization role of the user.", alias="orgRole")
    private_info: Optional[StrictBool] = Field(default=None, description="Specifies whether to update the private fields of the user.", alias="privateInfo")
    role: Optional[StrictBool] = Field(default=None, description="Specifies whether to update the role of the user.")
    show_tutorial: Optional[StrictBool] = Field(default=None, description="Specifies whether to update the tutorial status of the user.", alias="showTutorial")
    __properties: ClassVar[List[str]] = ["fullName", "orgRole", "privateInfo", "role", "showTutorial"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserWriteMask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserWriteMask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fullName": obj.get("fullName"),
            "orgRole": obj.get("orgRole"),
            "privateInfo": obj.get("privateInfo"),
            "role": obj.get("role"),
            "showTutorial": obj.get("showTutorial")
        })
        return _obj


