# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `rime-api-key` header.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.apiclient.models.id import ID
from typing import Optional, Set
from typing_extensions import Self

class Workspace(BaseModel):
    """
    Workspace
    """ # noqa: E501
    agent_ids: Optional[List[ID]] = Field(default=None, description="List of Agent IDs that can be used by the Workspace.", alias="agentIds")
    default_agent_id: Optional[ID] = Field(default=None, alias="defaultAgentId")
    description: Optional[StrictStr] = Field(default=None, description="Description of the Workspace.")
    name: Optional[StrictStr] = Field(default=None, description="Name of the Workspace.")
    results_retention_in_days: Optional[StrictInt] = Field(default=None, alias="resultsRetentionInDays")
    workspace_id: Optional[ID] = Field(default=None, alias="workspaceId")
    __properties: ClassVar[List[str]] = ["agentIds", "defaultAgentId", "description", "name", "resultsRetentionInDays", "workspaceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in agent_ids (list)
        _items = []
        if self.agent_ids:
            for _item in self.agent_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['agentIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of default_agent_id
        if self.default_agent_id:
            _dict['defaultAgentId'] = self.default_agent_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace_id
        if self.workspace_id:
            _dict['workspaceId'] = self.workspace_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agentIds": [ID.from_dict(_item) for _item in obj["agentIds"]] if obj.get("agentIds") is not None else None,
            "defaultAgentId": ID.from_dict(obj["defaultAgentId"]) if obj.get("defaultAgentId") is not None else None,
            "description": obj.get("description"),
            "name": obj.get("name"),
            "resultsRetentionInDays": obj.get("resultsRetentionInDays"),
            "workspaceId": ID.from_dict(obj["workspaceId"]) if obj.get("workspaceId") is not None else None
        })
        return _obj


