# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from datetime import datetime
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr
from ri.fwclient.models.get_firewall_instance_response import GetFirewallInstanceResponse
from ri.fwclient.models.list_firewall_instances_response import ListFirewallInstancesResponse

from ri.fwclient.models import *
from ri.fwclient.api_client import ApiClient, RequestSerialized
from ri.fwclient.api_response import ApiResponse
from ri.fwclient.rest import RESTResponseType


class FirewallInstanceManagerApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_instance(
        self,
        firewall_instance_id: str,
    ) -> GetFirewallInstanceResponse:
        """GetFirewallInstance

        Gets information about a single Firewall Instance.

        :param firewall_instance_id: (required)
        :type firewall_instance_id: str
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_instance_serialize(
            firewall_instance_id=firewall_instance_id,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFirewallInstanceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _get_instance_serialize(
        self,
        firewall_instance_id,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        if firewall_instance_id is not None:
            _path_params['firewallInstanceId'] = firewall_instance_id
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'X-Firewall-Auth-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/firewalls/{firewallInstanceId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )

    @validate_call
    def list_instances(
        self,
    ) -> ListFirewallInstancesResponse:
        """ListFirewallInstances

        Lists the Firewall Instances on the cluster.

        :return: Returns the result object.
        """ # noqa: E501


        _param = self._list_instances_serialize(
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFirewallInstancesResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    def _list_instances_serialize(
        self,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        _auth_settings: List[str] = [
            'X-Firewall-Auth-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1-beta/firewalls',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
        )
