# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class AttackTechnique(str, Enum):
    """
    AttackTechnique is the specific prompt injection technique found in the task.
    """

    """
    allowed enum values
    """
    ATTACK_TECHNIQUE_UNSPECIFIED = 'ATTACK_TECHNIQUE_UNSPECIFIED'
    ATTACK_TECHNIQUE_TASTLE = 'ATTACK_TECHNIQUE_TASTLE'
    ATTACK_TECHNIQUE_SYSTEM_INSTRUCTION_MODIFICATION = 'ATTACK_TECHNIQUE_SYSTEM_INSTRUCTION_MODIFICATION'
    ATTACK_TECHNIQUE_ROLE_PLAY_JAIL_BREAKS = 'ATTACK_TECHNIQUE_ROLE_PLAY_JAIL_BREAKS'
    ATTACK_TECHNIQUE_SYSTEM_INSTRUCTION_OVERRIDE = 'ATTACK_TECHNIQUE_SYSTEM_INSTRUCTION_OVERRIDE'
    ATTACK_TECHNIQUE_GLITCH_TOKENS = 'ATTACK_TECHNIQUE_GLITCH_TOKENS'
    ATTACK_TECHNIQUE_DRA_JAILBREAK = 'ATTACK_TECHNIQUE_DRA_JAILBREAK'
    ATTACK_TECHNIQUE_DEEP_INCEPTION = 'ATTACK_TECHNIQUE_DEEP_INCEPTION'
    ATTACK_TECHNIQUE_SIMPLE_ADAPTIVE_JAILBREAK = 'ATTACK_TECHNIQUE_SIMPLE_ADAPTIVE_JAILBREAK'
    ATTACK_TECHNIQUE_BOOST_STOP_TOKENS = 'ATTACK_TECHNIQUE_BOOST_STOP_TOKENS'
    ATTACK_TECHNIQUE_JAMBENCH = 'ATTACK_TECHNIQUE_JAMBENCH'
    ATTACK_TECHNIQUE_RENELLM = 'ATTACK_TECHNIQUE_RENELLM'
    ATTACK_TECHNIQUE_MARKDOWN_EXFILTRATION = 'ATTACK_TECHNIQUE_MARKDOWN_EXFILTRATION'
    ATTACK_TECHNIQUE_TAP = 'ATTACK_TECHNIQUE_TAP'
    ATTACK_TECHNIQUE_PLINY_GEMINI_JAILBREAK = 'ATTACK_TECHNIQUE_PLINY_GEMINI_JAILBREAK'
    ATTACK_TECHNIQUE_WIPI_PROMPT_INJECTION = 'ATTACK_TECHNIQUE_WIPI_PROMPT_INJECTION'
    ATTACK_TECHNIQUE_COMMON_PIT = 'ATTACK_TECHNIQUE_COMMON_PIT'
    ATTACK_TECHNIQUE_SKELETON_KEY = 'ATTACK_TECHNIQUE_SKELETON_KEY'
    ATTACK_TECHNIQUE_PLINY_GENERIC = 'ATTACK_TECHNIQUE_PLINY_GENERIC'
    ATTACK_TECHNIQUE_POLICY_PUPPETRY = 'ATTACK_TECHNIQUE_POLICY_PUPPETRY'
    ATTACK_TECHNIQUE_SEQAR_JAILBREAK = 'ATTACK_TECHNIQUE_SEQAR_JAILBREAK'
    ATTACK_TECHNIQUE_FLIP_ATTACK = 'ATTACK_TECHNIQUE_FLIP_ATTACK'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of AttackTechnique from a JSON string"""
        return cls(json.loads(json_str))


