# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.fwclient.models.detection_config import DetectionConfig
from ri.fwclient.models.guardrail_scan_ruleset import GuardrailScanRuleset
from typing import Optional, Set
from typing_extensions import Self

class GuardrailScanRequest(BaseModel):
    """
    This conforms to the `guardrailRequest` schema in AI Defense. protolint:disable MAX_LINE_LENGTH https://github.com/cisco-sbg/ai-firewall-services/blob/b5161bc8eb5a271d4cf5238d418d7ecbf1575c63/orchestrator/guardrails/types.go#L57-L62.
    """ # noqa: E501
    detection_config: Optional[DetectionConfig] = Field(default=None, alias="detectionConfig")
    firewall_instance_id: Optional[Dict[str, Any]] = Field(default=None, description="Unique ID of an object in RIME.", alias="firewallInstanceId")
    language: Optional[StrictStr] = Field(default=None, description="Language of the policy.")
    query: Optional[StrictStr] = Field(default=None, description="A JSON string representing the conversation history included in a request to the LLM API.")
    response: Optional[StrictStr] = Field(default=None, description="A JSON string representing the LLM API response.")
    ruleset_types: Optional[List[GuardrailScanRuleset]] = Field(default=None, description="List of rulesets to scan against.", alias="rulesetTypes")
    tools: Optional[StrictStr] = Field(default=None, description="A JSON string representing the tools included in the request to the LLM API.")
    __properties: ClassVar[List[str]] = ["detectionConfig", "firewallInstanceId", "language", "query", "response", "rulesetTypes", "tools"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GuardrailScanRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of detection_config
        if self.detection_config:
            _dict['detectionConfig'] = self.detection_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ruleset_types (list)
        _items = []
        if self.ruleset_types:
            for _item in self.ruleset_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rulesetTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GuardrailScanRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "detectionConfig": DetectionConfig.from_dict(obj["detectionConfig"]) if obj.get("detectionConfig") is not None else None,
            "firewallInstanceId": obj.get("firewallInstanceId"),
            "language": obj.get("language"),
            "query": obj.get("query"),
            "response": obj.get("response"),
            "rulesetTypes": [GuardrailScanRuleset.from_dict(_item) for _item in obj["rulesetTypes"]] if obj.get("rulesetTypes") is not None else None,
            "tools": obj.get("tools")
        })
        return _obj


