# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.fwclient.models.pii_detection_rule_config import PiiDetectionRuleConfig
from ri.fwclient.models.prompt_injection_rule_config import PromptInjectionRuleConfig
from ri.fwclient.models.toxicity_rule_config import ToxicityRuleConfig
from typing import Optional, Set
from typing_extensions import Self

class IndividualRulesConfig(BaseModel):
    """
    IndividualRulesConfig contains configuration parameters for each individual rule.
    """ # noqa: E501
    pii_detection_input: Optional[PiiDetectionRuleConfig] = Field(default=None, alias="piiDetectionInput")
    pii_detection_output: Optional[PiiDetectionRuleConfig] = Field(default=None, alias="piiDetectionOutput")
    prompt_injection_input: Optional[PromptInjectionRuleConfig] = Field(default=None, alias="promptInjectionInput")
    toxicity_input: Optional[ToxicityRuleConfig] = Field(default=None, alias="toxicityInput")
    toxicity_output: Optional[ToxicityRuleConfig] = Field(default=None, alias="toxicityOutput")
    __properties: ClassVar[List[str]] = ["piiDetectionInput", "piiDetectionOutput", "promptInjectionInput", "toxicityInput", "toxicityOutput"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IndividualRulesConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pii_detection_input
        if self.pii_detection_input:
            _dict['piiDetectionInput'] = self.pii_detection_input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pii_detection_output
        if self.pii_detection_output:
            _dict['piiDetectionOutput'] = self.pii_detection_output.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prompt_injection_input
        if self.prompt_injection_input:
            _dict['promptInjectionInput'] = self.prompt_injection_input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of toxicity_input
        if self.toxicity_input:
            _dict['toxicityInput'] = self.toxicity_input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of toxicity_output
        if self.toxicity_output:
            _dict['toxicityOutput'] = self.toxicity_output.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IndividualRulesConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "piiDetectionInput": PiiDetectionRuleConfig.from_dict(obj["piiDetectionInput"]) if obj.get("piiDetectionInput") is not None else None,
            "piiDetectionOutput": PiiDetectionRuleConfig.from_dict(obj["piiDetectionOutput"]) if obj.get("piiDetectionOutput") is not None else None,
            "promptInjectionInput": PromptInjectionRuleConfig.from_dict(obj["promptInjectionInput"]) if obj.get("promptInjectionInput") is not None else None,
            "toxicityInput": ToxicityRuleConfig.from_dict(obj["toxicityInput"]) if obj.get("toxicityInput") is not None else None,
            "toxicityOutput": ToxicityRuleConfig.from_dict(obj["toxicityOutput"]) if obj.get("toxicityOutput") is not None else None
        })
        return _obj


