# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.fwclient.models.code_detection_details import CodeDetectionDetails
from ri.fwclient.models.firewall_action import FirewallAction
from ri.fwclient.models.language_detection_details import LanguageDetectionDetails
from ri.fwclient.models.pii_detection_details import PiiDetectionDetails
from ri.fwclient.models.prompt_injection_details import PromptInjectionDetails
from ri.fwclient.models.standard_info import StandardInfo
from ri.fwclient.models.toxicity_detection_details import ToxicityDetectionDetails
from typing import Optional, Set
from typing_extensions import Self

class RuleDetails(BaseModel):
    """
    RuleDetails represents the user-facing information about each rule evaluation during a call to Firewall Validate.
    """ # noqa: E501
    action: Optional[FirewallAction] = None
    code_detection_details: Optional[CodeDetectionDetails] = Field(default=None, alias="codeDetectionDetails")
    language_detection_details: Optional[LanguageDetectionDetails] = Field(default=None, alias="languageDetectionDetails")
    pii_detection_details: Optional[PiiDetectionDetails] = Field(default=None, alias="piiDetectionDetails")
    prompt_injection_details: Optional[PromptInjectionDetails] = Field(default=None, alias="promptInjectionDetails")
    rule_name: Optional[StrictStr] = Field(default=None, alias="ruleName")
    security_standards: Optional[List[StandardInfo]] = Field(default=None, description="Security standards encodes which regulatory standards (MITRE, OWASP) are addressed by this firewall rule.", alias="securityStandards")
    toxicity_detection_details: Optional[ToxicityDetectionDetails] = Field(default=None, alias="toxicityDetectionDetails")
    __properties: ClassVar[List[str]] = ["action", "codeDetectionDetails", "languageDetectionDetails", "piiDetectionDetails", "promptInjectionDetails", "ruleName", "securityStandards", "toxicityDetectionDetails"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of code_detection_details
        if self.code_detection_details:
            _dict['codeDetectionDetails'] = self.code_detection_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of language_detection_details
        if self.language_detection_details:
            _dict['languageDetectionDetails'] = self.language_detection_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pii_detection_details
        if self.pii_detection_details:
            _dict['piiDetectionDetails'] = self.pii_detection_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prompt_injection_details
        if self.prompt_injection_details:
            _dict['promptInjectionDetails'] = self.prompt_injection_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in security_standards (list)
        _items = []
        if self.security_standards:
            for _item in self.security_standards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['securityStandards'] = _items
        # override the default output from pydantic by calling `to_dict()` of toxicity_detection_details
        if self.toxicity_detection_details:
            _dict['toxicityDetectionDetails'] = self.toxicity_detection_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "codeDetectionDetails": CodeDetectionDetails.from_dict(obj["codeDetectionDetails"]) if obj.get("codeDetectionDetails") is not None else None,
            "languageDetectionDetails": LanguageDetectionDetails.from_dict(obj["languageDetectionDetails"]) if obj.get("languageDetectionDetails") is not None else None,
            "piiDetectionDetails": PiiDetectionDetails.from_dict(obj["piiDetectionDetails"]) if obj.get("piiDetectionDetails") is not None else None,
            "promptInjectionDetails": PromptInjectionDetails.from_dict(obj["promptInjectionDetails"]) if obj.get("promptInjectionDetails") is not None else None,
            "ruleName": obj.get("ruleName"),
            "securityStandards": [StandardInfo.from_dict(_item) for _item in obj["securityStandards"]] if obj.get("securityStandards") is not None else None,
            "toxicityDetectionDetails": ToxicityDetectionDetails.from_dict(obj["toxicityDetectionDetails"]) if obj.get("toxicityDetectionDetails") is not None else None
        })
        return _obj


