# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ri.fwclient.models.model_info import ModelInfo
from ri.fwclient.models.yara_info import YaraInfo
from typing import Optional, Set
from typing_extensions import Self

class RuleEvaluationMetadata(BaseModel):
    """
    RuleEvaluationMetadata
    """ # noqa: E501
    evaluation_models: Optional[Dict[str, ModelInfo]] = Field(default=None, description="Map from the name of the model (`prompt-injection`, `toxicity`) to information about how it was used in evaluation.", alias="evaluationModels")
    yara_info: Optional[YaraInfo] = Field(default=None, alias="yaraInfo")
    __properties: ClassVar[List[str]] = ["evaluationModels", "yaraInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleEvaluationMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in evaluation_models (dict)
        _field_dict = {}
        if self.evaluation_models:
            for _key in self.evaluation_models:
                if self.evaluation_models[_key]:
                    _field_dict[_key] = self.evaluation_models[_key].to_dict()
            _dict['evaluationModels'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of yara_info
        if self.yara_info:
            _dict['yaraInfo'] = self.yara_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleEvaluationMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "evaluationModels": dict(
                (_k, ModelInfo.from_dict(_v))
                for _k, _v in obj["evaluationModels"].items()
            )
            if obj.get("evaluationModels") is not None
            else None,
            "yaraInfo": YaraInfo.from_dict(obj["yaraInfo"]) if obj.get("yaraInfo") is not None else None
        })
        return _obj


