# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RuleType(str, Enum):
    """
    RuleType specifies the different rules for the firewall.   - RULE_TYPE_TOXICITY_INPUT: Toxicity checks for toxic text in the model's input.  - RULE_TYPE_TOXICITY_OUTPUT: Toxicity checks for toxic text in the model's output.  - RULE_TYPE_PII_DETECTION_INPUT: PII detection validates that the model input does not include personal information.  - RULE_TYPE_PII_DETECTION_OUTPUT: PII detection validates that the model output does not leak personal information.  - RULE_TYPE_PROMPT_INJECTION_INPUT: Prompt injection flags user input text that contain prompt injection attacks.  - RULE_TYPE_CODE_DETECTION_INPUT: Code detection input flags code presence in the model's input.  - RULE_TYPE_CODE_DETECTION_OUTPUT: Code detection output flags code presence in the model's output.
    """

    """
    allowed enum values
    """
    RULE_TYPE_TOXICITY_INPUT = 'RULE_TYPE_TOXICITY_INPUT'
    RULE_TYPE_TOXICITY_OUTPUT = 'RULE_TYPE_TOXICITY_OUTPUT'
    RULE_TYPE_PII_DETECTION_INPUT = 'RULE_TYPE_PII_DETECTION_INPUT'
    RULE_TYPE_PII_DETECTION_OUTPUT = 'RULE_TYPE_PII_DETECTION_OUTPUT'
    RULE_TYPE_PROMPT_INJECTION_INPUT = 'RULE_TYPE_PROMPT_INJECTION_INPUT'
    RULE_TYPE_CODE_DETECTION_INPUT = 'RULE_TYPE_CODE_DETECTION_INPUT'
    RULE_TYPE_CODE_DETECTION_OUTPUT = 'RULE_TYPE_CODE_DETECTION_OUTPUT'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RuleType from a JSON string"""
        return cls(json.loads(json_str))


