# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.fwclient.models.rule_output import RuleOutput
from ri.fwclient.models.validate_response import ValidateResponse
from typing import Optional, Set
from typing_extensions import Self

class TelemetryLog(BaseModel):
    """
    TelemetryLog is the comprehensive log of all the information related to a single validation request.
    """ # noqa: E501
    firewall_validate_response: Optional[ValidateResponse] = Field(default=None, alias="firewallValidateResponse")
    rules_results: Optional[Dict[str, RuleOutput]] = Field(default=None, description="Results of the firewall for every rule that was run. The key is a rule name.", alias="rulesResults")
    schema_version: Optional[StrictStr] = Field(default=None, description="Telemetry log schema version is the version of the log. This should be updated whenever we make semantic changes to the log.", alias="schemaVersion")
    validation_time: Optional[datetime] = Field(default=None, description="Date and time at which the Firewall allowed or denied this request.", alias="validationTime")
    __properties: ClassVar[List[str]] = ["firewallValidateResponse", "rulesResults", "schemaVersion", "validationTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TelemetryLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of firewall_validate_response
        if self.firewall_validate_response:
            _dict['firewallValidateResponse'] = self.firewall_validate_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in rules_results (dict)
        _field_dict = {}
        if self.rules_results:
            for _key in self.rules_results:
                if self.rules_results[_key]:
                    _field_dict[_key] = self.rules_results[_key].to_dict()
            _dict['rulesResults'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TelemetryLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firewallValidateResponse": ValidateResponse.from_dict(obj["firewallValidateResponse"]) if obj.get("firewallValidateResponse") is not None else None,
            "rulesResults": dict(
                (_k, RuleOutput.from_dict(_v))
                for _k, _v in obj["rulesResults"].items()
            )
            if obj.get("rulesResults") is not None
            else None,
            "schemaVersion": obj.get("schemaVersion"),
            "validationTime": obj.get("validationTime")
        })
        return _obj


