# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ri.fwclient.models.id import ID
from ri.fwclient.models.processed_request import ProcessedRequest
from ri.fwclient.models.rule_details import RuleDetails
from ri.fwclient.models.validation_type import ValidationType
from typing import Optional, Set
from typing_extensions import Self

class ValidateResponse(BaseModel):
    """
    ValidateResponse is the response to a single validation request. Note: this does not follow the same RI API standards, because we want this to be easily consumed by security team's event frameworks.
    """ # noqa: E501
    allowed_rules: Optional[Dict[str, RuleDetails]] = Field(default=None, description="Complete list of all rules that allowed the input or output.", alias="allowedRules")
    firewall_instance_id: Optional[ID] = Field(default=None, alias="firewallInstanceId")
    flagged_rules: Optional[Dict[str, RuleDetails]] = Field(default=None, description="Complete list of all rules that flagged the input or output.", alias="flaggedRules")
    flagged_validation_types: Optional[List[ValidationType]] = Field(default=None, description="Lists what was flagged- the input, the output, or both. This is always a subset of validation_types.", alias="flaggedValidationTypes")
    language: Optional[StrictStr] = None
    product: Optional[StrictStr] = Field(default=None, description="The name of the product that is processing this request.")
    request: Optional[ProcessedRequest] = None
    schema_version: Optional[StrictStr] = Field(default=None, description="API schema version is the version of the API response. This should be updated whenever we make semantic changes to the response.", alias="schemaVersion")
    trace_id: Optional[ID] = Field(default=None, alias="traceId")
    validation_time: Optional[datetime] = Field(default=None, description="Date and time at which the Firewall allowed or denied this request.", alias="validationTime")
    validation_types: Optional[List[ValidationType]] = Field(default=None, description="Lists what was scanned- the input, the output, or both.", alias="validationTypes")
    vendor_name: Optional[StrictStr] = Field(default=None, description="The name of the entity that manages the Firewall Instance.", alias="vendorName")
    version: Optional[StrictStr] = Field(default=None, description="Firewall semantic version.")
    __properties: ClassVar[List[str]] = ["allowedRules", "firewallInstanceId", "flaggedRules", "flaggedValidationTypes", "language", "product", "request", "schemaVersion", "traceId", "validationTime", "validationTypes", "vendorName", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ValidateResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in allowed_rules (dict)
        _field_dict = {}
        if self.allowed_rules:
            for _key in self.allowed_rules:
                if self.allowed_rules[_key]:
                    _field_dict[_key] = self.allowed_rules[_key].to_dict()
            _dict['allowedRules'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of firewall_instance_id
        if self.firewall_instance_id:
            _dict['firewallInstanceId'] = self.firewall_instance_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in flagged_rules (dict)
        _field_dict = {}
        if self.flagged_rules:
            for _key in self.flagged_rules:
                if self.flagged_rules[_key]:
                    _field_dict[_key] = self.flagged_rules[_key].to_dict()
            _dict['flaggedRules'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trace_id
        if self.trace_id:
            _dict['traceId'] = self.trace_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ValidateResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowedRules": dict(
                (_k, RuleDetails.from_dict(_v))
                for _k, _v in obj["allowedRules"].items()
            )
            if obj.get("allowedRules") is not None
            else None,
            "firewallInstanceId": ID.from_dict(obj["firewallInstanceId"]) if obj.get("firewallInstanceId") is not None else None,
            "flaggedRules": dict(
                (_k, RuleDetails.from_dict(_v))
                for _k, _v in obj["flaggedRules"].items()
            )
            if obj.get("flaggedRules") is not None
            else None,
            "flaggedValidationTypes": obj.get("flaggedValidationTypes"),
            "language": obj.get("language"),
            "product": obj.get("product"),
            "request": ProcessedRequest.from_dict(obj["request"]) if obj.get("request") is not None else None,
            "schemaVersion": obj.get("schemaVersion"),
            "traceId": ID.from_dict(obj["traceId"]) if obj.get("traceId") is not None else None,
            "validationTime": obj.get("validationTime"),
            "validationTypes": obj.get("validationTypes"),
            "vendorName": obj.get("vendorName"),
            "version": obj.get("version")
        })
        return _obj


