# coding: utf-8

"""
    Robust Intelligence Firewall REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` header. Your AI Firewall Agent domain forms the base of the URL for REST API calls. To find the Agent domain in the Robust Intelligence UI, click AI Firewall: Settings icon: Firewall Settings. Find your agent in the Firewall Agent Status: Agents Setup page, and copy its URL from the table.

    The version of the OpenAPI document: 1.0
    Contact: dev@robustintelligence.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import unittest

from ri.fwclient.models.rule_output import RuleOutput

class TestRuleOutput(unittest.TestCase):
    """RuleOutput unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> RuleOutput:
        """Test RuleOutput
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `RuleOutput`
        """
        model = RuleOutput()
        if include_optional:
            return RuleOutput(
                details = ri.fwclient.models.rule_details.RuleDetails(
                    action = 'FIREWALL_ACTION_UNSPECIFIED', 
                    code_detection_details = ri.fwclient.models.code_detection_details.CodeDetectionDetails(
                        flagged_code_substrings = [
                            ri.fwclient.models.code_substring.CodeSubstring(
                                flagged_substring = ri.fwclient.models.flagged_substring.FlaggedSubstring(
                                    request_body_component = 'REQUEST_BODY_COMPONENT_UNSPECIFIED', 
                                    substring_end_index = 56, 
                                    substring_start_index = 56, ), 
                                language = '', )
                            ], ), 
                    language_detection_details = ri.fwclient.models.language_detection_details.LanguageDetectionDetails(
                        flagged_language_substrings = [
                            ri.fwclient.models.language_substring.LanguageSubstring(
                                language_code = '', )
                            ], ), 
                    pii_detection_details = ri.fwclient.models.pii_detection_details.PiiDetectionDetails(
                        flagged_entities = [
                            ri.fwclient.models.flagged_entity.FlaggedEntity(
                                confidence_score = 1.337, 
                                custom_entity_name = '', 
                                entity_type = 'PII_ENTITY_TYPE_UNSPECIFIED', )
                            ], 
                        sanitized_text = '', ), 
                    prompt_injection_details = ri.fwclient.models.prompt_injection_details.PromptInjectionDetails(
                        objectives = [
                            'ATTACK_OBJECTIVE_UNSPECIFIED'
                            ], 
                        techniques = [
                            'ATTACK_TECHNIQUE_UNSPECIFIED'
                            ], ), 
                    rule_name = '', 
                    security_standards = [
                        ri.fwclient.models.container_for_an_ai_risk_standard_(e/g/_nist).Container for an AI risk standard (e.g. NIST)(
                            description = '', )
                        ], 
                    toxicity_detection_details = ri.fwclient.models.toxicity_detection_details.ToxicityDetectionDetails(
                        categories = [
                            'TOXICITY_THREAT_CATEGORY_UNSPECIFIED'
                            ], ), ),
                rule_eval_metadata = ri.fwclient.models.rule_evaluation_metadata.RuleEvaluationMetadata(
                    evaluation_models = {
                        'key' : ri.fwclient.models.model_info.ModelInfo(
                            chunk_scores = [
                                ri.fwclient.models.raw_model_prediction.RawModelPrediction(
                                    classification_pred = ri.fwclient.models.text_classification_pred.TextClassificationPred(
                                        scores = [
                                            1.337
                                            ], ), )
                                ], 
                            model_version = '', )
                        }, 
                    yara_info = ri.fwclient.models.yara_info.YaraInfo(
                        action = 'FIREWALL_ACTION_UNSPECIFIED', 
                        is_decisive_match = True, 
                        matched_by_rules = [
                            ''
                            ], 
                        version_info = ri.fwclient.models.yara_version_info.YaraVersionInfo(
                            git_ref = '', 
                            latest_commit_hash = '', ), ), )
            )
        else:
            return RuleOutput(
        )
        """

    def testRuleOutput(self):
        """Test RuleOutput"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()