from typing import AsyncGenerator

import pytest
from mongomock_motor import AsyncMongoMockClient
from motor.motor_asyncio import AsyncIOMotorClient
from objectdb.database_mongodb import MongoDBDatabase  # your class


@pytest.fixture
async def mongo_db() -> AsyncGenerator[MongoDBDatabase, None]:
    """Return a MongoDBDatabase instance backed by mongomock_motor."""
    client: AsyncIOMotorClient = AsyncMongoMockClient()
    db = MongoDBDatabase(mongodb_client=client, name="test_db")
    yield db
    await client.drop_database("test_db")
