# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.aggregation_response import AggregationResponse
from ..types.aggregation_result import AggregationResult
from ..types.continuous_query_task_history_response import ContinuousQueryTaskHistoryResponse
from ..types.query import Query
from ..types.query_config import QueryConfig
from .raw_client import AsyncRawAggregateClient, RawAggregateClient
from .types.query_batch_timeframe import QueryBatchTimeframe

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AggregateClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAggregateClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAggregateClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAggregateClient
        """
        return self._raw_client

    def query_one(
        self,
        user_id: str,
        *,
        timeframe: QueryBatchTimeframe,
        queries: typing.Sequence[Query],
        config: typing.Optional[QueryConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AggregationResponse:
        """
        Parameters
        ----------
        user_id : str

        timeframe : QueryBatchTimeframe

        queries : typing.Sequence[Query]

        config : typing.Optional[QueryConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AggregationResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import RelativeTimeframe
        from vital import Period
        from vital import PeriodUnit
        from vital import Query
        from vital import AggregateExpr
        from vital import SleepColumnExpr
        from vital import SleepColumnExprSleep
        from vital import AggregateExprFunc
        client = Vital(api_key="YOUR_API_KEY", )
        client.aggregate.query_one(user_id='user_id', timeframe=RelativeTimeframe(anchor='anchor', past=Period(unit=PeriodUnit.MINUTE, ), ), queries=[Query(select=[AggregateExpr(arg=SleepColumnExpr(sleep=SleepColumnExprSleep.SESSION_START, ), func=AggregateExprFunc.MEAN, )], )], )
        """
        _response = self._raw_client.query_one(
            user_id, timeframe=timeframe, queries=queries, config=config, request_options=request_options
        )
        return _response.data

    def get_result_table_for_continuous_query(
        self, user_id: str, query_id_or_slug: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AggregationResult:
        """
        Parameters
        ----------
        user_id : str

        query_id_or_slug : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AggregationResult
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.aggregate.get_result_table_for_continuous_query(user_id='user_id', query_id_or_slug='query_id_or_slug', )
        """
        _response = self._raw_client.get_result_table_for_continuous_query(
            user_id, query_id_or_slug, request_options=request_options
        )
        return _response.data

    def get_task_history_for_continuous_query(
        self,
        user_id: str,
        query_id_or_slug: str,
        *,
        next_cursor: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContinuousQueryTaskHistoryResponse:
        """
        Parameters
        ----------
        user_id : str

        query_id_or_slug : str

        next_cursor : typing.Optional[str]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContinuousQueryTaskHistoryResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.aggregate.get_task_history_for_continuous_query(user_id='user_id', query_id_or_slug='query_id_or_slug', )
        """
        _response = self._raw_client.get_task_history_for_continuous_query(
            user_id, query_id_or_slug, next_cursor=next_cursor, limit=limit, request_options=request_options
        )
        return _response.data


class AsyncAggregateClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAggregateClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAggregateClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAggregateClient
        """
        return self._raw_client

    async def query_one(
        self,
        user_id: str,
        *,
        timeframe: QueryBatchTimeframe,
        queries: typing.Sequence[Query],
        config: typing.Optional[QueryConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AggregationResponse:
        """
        Parameters
        ----------
        user_id : str

        timeframe : QueryBatchTimeframe

        queries : typing.Sequence[Query]

        config : typing.Optional[QueryConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AggregationResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import RelativeTimeframe
        from vital import Period
        from vital import PeriodUnit
        from vital import Query
        from vital import AggregateExpr
        from vital import SleepColumnExpr
        from vital import SleepColumnExprSleep
        from vital import AggregateExprFunc
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.aggregate.query_one(user_id='user_id', timeframe=RelativeTimeframe(anchor='anchor', past=Period(unit=PeriodUnit.MINUTE, ), ), queries=[Query(select=[AggregateExpr(arg=SleepColumnExpr(sleep=SleepColumnExprSleep.SESSION_START, ), func=AggregateExprFunc.MEAN, )], )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.query_one(
            user_id, timeframe=timeframe, queries=queries, config=config, request_options=request_options
        )
        return _response.data

    async def get_result_table_for_continuous_query(
        self, user_id: str, query_id_or_slug: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AggregationResult:
        """
        Parameters
        ----------
        user_id : str

        query_id_or_slug : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AggregationResult
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.aggregate.get_result_table_for_continuous_query(user_id='user_id', query_id_or_slug='query_id_or_slug', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_result_table_for_continuous_query(
            user_id, query_id_or_slug, request_options=request_options
        )
        return _response.data

    async def get_task_history_for_continuous_query(
        self,
        user_id: str,
        query_id_or_slug: str,
        *,
        next_cursor: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContinuousQueryTaskHistoryResponse:
        """
        Parameters
        ----------
        user_id : str

        query_id_or_slug : str

        next_cursor : typing.Optional[str]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContinuousQueryTaskHistoryResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.aggregate.get_task_history_for_continuous_query(user_id='user_id', query_id_or_slug='query_id_or_slug', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_task_history_for_continuous_query(
            user_id, query_id_or_slug, next_cursor=next_cursor, limit=limit, request_options=request_options
        )
        return _response.data
