# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.address import Address
from ..types.client_facing_payor import ClientFacingPayor
from ..types.http_validation_error import HttpValidationError
from ..types.payor_code_external_provider import PayorCodeExternalProvider

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPayorClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_payor(
        self,
        *,
        name: str,
        address: Address,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_payor_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingPayor]:
        """
        Parameters
        ----------
        name : str

        address : Address

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingPayor]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/payor",
            method="POST",
            json={
                "name": name,
                "address": address,
                "provider": provider,
                "provider_payor_id": provider_payor_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingPayor,
                    parse_obj_as(
                        type_=ClientFacingPayor,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPayorClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_payor(
        self,
        *,
        name: str,
        address: Address,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_payor_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingPayor]:
        """
        Parameters
        ----------
        name : str

        address : Address

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingPayor]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/payor",
            method="POST",
            json={
                "name": name,
                "address": address,
                "provider": provider,
                "provider_payor_id": provider_payor_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingPayor,
                    parse_obj_as(
                        type_=ClientFacingPayor,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
