# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClientFacingProvider(UniversalBaseModel):
    """
    A vendor, a service, or a platform which Vital can connect with.
    """

    name: str = pydantic.Field()
    """
    Name of source of information
    """

    slug: str = pydantic.Field()
    """
    Slug for designated source
    """

    logo: str = pydantic.Field()
    """
    URL for source logo
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
