# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connected_source_client_facing import ConnectedSourceClientFacing
from .fallback_birth_date import FallbackBirthDate
from .fallback_time_zone import FallbackTimeZone


class ClientFacingUser(UniversalBaseModel):
    user_id: str = pydantic.Field()
    """
    User id returned by vital create user request. This id should be stored in your database against the user and used for all interactions with the vital api.
    """

    team_id: str = pydantic.Field()
    """
    Your team id.
    """

    client_user_id: str = pydantic.Field()
    """
    A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.
    """

    created_on: dt.datetime = pydantic.Field()
    """
    When your item is created
    """

    connected_sources: typing.List[ConnectedSourceClientFacing] = pydantic.Field()
    """
    A list of the users connected sources.
    """

    fallback_time_zone: typing.Optional[FallbackTimeZone] = pydantic.Field(default=None)
    """
    
        Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
        Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).
        
    """

    fallback_birth_date: typing.Optional[FallbackBirthDate] = pydantic.Field(default=None)
    """
    Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.
    """

    ingestion_start: typing.Optional[str] = pydantic.Field(default=None)
    """
    Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).
    """

    ingestion_end: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
