# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .clinical_information import ClinicalInformation
from .performing_laboratory import PerformingLaboratory
from .sample_data_date_collected import SampleDataDateCollected
from .sample_data_date_received import SampleDataDateReceived
from .sample_data_date_reported import SampleDataDateReported


class SampleData(UniversalBaseModel):
    sample_id: typing.Optional[str] = None
    control_number: typing.Optional[str] = None
    date_collected: typing.Optional[SampleDataDateCollected] = None
    date_received: typing.Optional[SampleDataDateReceived] = None
    date_reported: typing.Optional[SampleDataDateReported] = None
    performing_laboratories: typing.Optional[typing.Dict[str, typing.Optional[PerformingLaboratory]]] = None
    clinical_information: typing.Optional[ClinicalInformation] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
